package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpallocatecreate;

import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class ErpStockAllocateRequestBizData extends BaseRequestBizData {

    // 基础信息
    private Integer allocateType;          // 调拨类型（0：同价调拨；1：异价调拨）
    private String allocatePrice;          // 调拨价格（1：批发价；2：零售价；3：会员价）
    private Long applyUserId;              // 申请人ID
    private String applyUserName;          // 申请人
    private Long applyDepartId;            // 申请部门ID
    private String departCode;             // 申请人部门编号
    private String applyDepartName;        // 申请部门
    private Date applyDate;                // 申请时间
    private String operator;               // 制单人
    private Long operatorId;               // 制单人ID
    private String companyCode;            // 公司编号
    private List<StockAllocateFile> stockAllocateFiles; // 附件信息
    private String logisticType;           // 物流类型（1：普通快递；2：上门自提；...）
    private String logisticNo;             // 物流单号
    private String logisticCode;           // 物流公司编码
    private String logisticName;           // 物流公司名称
    private String reason;                 // 原因
    private BigDecimal currencyRate;       // 入库汇率
    private String outCurrencyCode;        // 出库币种编码
    private String outCurrencyName;        // 出库币种名称
    private String inCurrencyCode;         // 入库币种编码
    private String inCurrencyName;         // 入库币种名称
    private BigDecimal inCountSum;         // 入库数量
    private BigDecimal outCountSum;        // 出库数量
    private BigDecimal returnedCountInSum; // 退回数量
    private String outWarehouseCode;       // 调出仓库编码
    private String intWarehouseCode;       // 调入仓库编码
    private Long auditUserId;              // 审核人ID
    private String auditUserName;          // 审核人
    private Date auditDate;                // 审核时间
    private Integer status;                // 审核状态（0：待递交；1：审核中；...）
    private Integer outStatus;             // 出库状态
    private Integer inStatus;              // 入库状态
    private String memo;                   // 备注
    private BigDecimal goodsCount;         // 货品种类
    private BigDecimal skuCount;           // 货品数量
    private BigDecimal totalAmount;        // 总金额
    private Date gmtCreate;                // 创建时间
    private Integer allocatePriceType;     // 调拨价格类型
    private Long companyId;                // 公司ID
    private String companyName;            // 公司名称
    private Date planOutDate;              // 预计出库时间
    private Date planInDate;               // 预计入库时间
    private List<StockAllocateDetailView> stockAllocateDetailViews; // 货品明细
    private Integer isNegativeStock;       // 是否允许负库存出库
    private StockAllocateExpressInfo stockAllocateExpressInfo; // 收发货信息
    private String sourceNo;               // 来源单号
    private Integer isAutoResolutionAddress; // 是否自动解析省市区
    private Integer isSetFromWarehouse;    // 是否自动取仓库收发件人
    private String field1;                 // 自定义字段1
    private String field2;                 // 自定义字段2
    private String field3;                 // 自定义字段3
    private String field4;                 // 自定义字段4
    private String field5;                 // 自定义字段5
    private String field6;                 // 自定义字段6
    private String field7;                 // 自定义字段7
    private String field8;                 // 自定义字段8
    private String field9;                 // 自定义字段9
    private String field10;                // 自定义字段10
    private Integer isCertified;           // 是否正品（必填）

    // 内部类：附件信息
    @Data
    public static class StockAllocateFile {
        private String fileName;
        private String fileUrl;
    }

    // 内部类：货品明细
    @Data
    public static class StockAllocateDetailView {
        private String goodsName;          // 货品名称
        private String skuName;            // SKU名称
        private String unitName;           // 计量单位名称
        private BigDecimal skuCount;       // 数量
        private BigDecimal skuPrice;       // 单价
        private Integer isBatch;           // 是否批次货品
        private Integer isSerial;          // 是否序列号货品
        private BigDecimal totalAmount;    // 总金额
        private List<Batch> batchList;     // 批次节点
        private String skuBarcode;         // 条形码
        private String outSkuCode;         // 外部货品编码
        private String goodsNo;            // 商品编号
        private Integer isCertified;       // 是否正品
        private String rowRemark;          // 备注
        private BigDecimal outCount;       // 已出库数量
        private BigDecimal inCount;        // 已入库数量
        // getters/setters
    }

    // 内部类：批次节点
    @Data
    public static class Batch {
        private String batchNo;            // 批次号
        private BigDecimal quantity;       // 货品数量
        private Date productionDate;       // 生产日期
        private String shelfLife;          // 质保期
        private String shelfLiftUnit;      // 质保期单位
        private Date expirationDate;       // 到期日期
        private String batchMemo;          // 批次备注

    }

    // 内部类：收发货信息
    @Data
    public static class StockAllocateExpressInfo {
        private String sendCompanyName;    // 发件公司名称
        private String send;               // 发件人
        private String sendTel;            // 发件人电话
        private String sendPhone;          // 发件人手机号
        private String sendEmail;          // 发件人邮箱
        private String sendCountryName;    // 发件人国家
        private String sendProvinceName;   // 发件人省
        private String sendCityName;       // 发件人市
        private String sendTownName;       // 发件人镇/区
        private String sendStreetName;     // 发件人街道
        private String sendAddress;        // 发件人详细地址
        private String receiveCompanyName; // 收件公司名称
        private String receive;            // 收件人
        private String receiveTel;         // 收件人电话
        private String receivePhone;       // 收件人手机号
        private String receiveEmail;       // 收件人邮箱
        private String receiveCountryName; // 收件人国家
        private String receiveProvinceName;// 收件人省
        private String receiveCityName;    // 收件人市
        private String receiveTownName;    // 收件人镇/区
        private String receiveStreetName;  // 收件人街道
        private String receiveAddress;     // 收件人详细地址
        // getters/setters
    }
}
