package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget;



import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

import java.util.List;

/**
 * @description: 分页查询入库申请单请求参数
 */
@Data
public class ErpStockInGetRequestBizData extends BaseRequestBizData {
	/**
	 * 分页页码 
	 */ 
	private Integer pageIndex;
	/**
	 * 分页页数 
	 */ 
	private Integer pageSize;
	/**
	 * 关联单据号 
	 */ 
	private String relDataId;
	/**
	 * 申请时间(截止),创建修改申请时间都为空，会默认查询申请时间为一个月内的数据 
	 */ 
	private String applyDateTo;
	/**
	 * 入库申请单号 
	 */ 
	private String inNo;
	/**
	 * 申请时间(起始)，创建修改申请时间都为空，会默认查询申请时间为一个月内的数据 
	 */ 
	private String applyDateFrom;
	/**
	 * 入库类型101=采购入库102=调拨入库103=盘盈入库104=其他入库 
	 */ 
	private String inType;
	/**
	 * 1未入库；2部分入库；3已入库, 
	 */ 
	private String inStatus;
	/**
	 * 仓库编号 
	 */ 
	private String warehouseCode;
	/**
	 * 不传查询全部通知状态的数据 
	 */ 
	private Integer isNotification;
	/**
	 * 修改时间（起始） 
	 */ 
	private String modifyTimeFrom;
	/**
	 * 修改时间（截止 不包含） 
	 */ 
	private String modifyTimeTo;


}

