package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 库存盘点查询请求参数
 * API: /open/inventory/count/query
 */
@Data
public class InventoryCountQueryRequest {

    @ApiModelProperty("第几页，从第一页开始，默认1")
    private Integer page_index;

    @ApiModelProperty("每页多少条，默认30，最大50")
    private Integer page_size;

    @ApiModelProperty("修改起始时间，和结束时间必须同时存在，时间间隔不能超过七天")
    private String modified_begin;

    @ApiModelProperty("修改结束时间，和起始时间必须同时存在，时间间隔不能超过七天")
    private String modified_end;

    @ApiModelProperty("指定盘点单号多个用逗号分隔，最多50，和时间段不能同时为空")
    private String io_ids;

    @ApiModelProperty("状态;WaitConfirm:待确认,Confirmed:生效,Archive:归档,Cancelled:取消,Delete:作废")
    private String status;

    @ApiModelProperty("货主编码（三方仓商家不传货主默认查自身数据，若查所有货主需传值：2147483647）")
    private Integer owner_co_id;
}
