package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 其它出入库查询请求参数
 * API: /open/other/inout/query
 */
@Data
public class OtherInOutQueryRequest {

    @ApiModelProperty("修改起始时间，和结束时间必须同时存在，时间间隔不能超过七天")
    private String modified_begin;

    @ApiModelProperty("修改结束时间，和起始时间必须同时存在，时间间隔不能超过七天")
    private String modified_end;

    @ApiModelProperty("指定线上订单号，和时间段不能同时为空，最多50个")
    private List<String> so_ids;

    @ApiModelProperty("单据类型:其它退货,其它出库,其它进仓")
    private List<String> types;

    @ApiModelProperty("单据状态，Confirmed生效，WaitConfirm待审核，OuterConfirming外部确认中，Cancelled取消，Delete作废")
    private String status;

    @ApiModelProperty("第几页，从第一页开始，默认1")
    private Integer page_index;

    @ApiModelProperty("每页多少条，默认30，最大50")
    private Integer page_size;

    @ApiModelProperty("分仓编号")
    private Integer wms_co_id;

    @ApiModelProperty("出仓单号列表，最多50个")
    private List<Integer> io_ids;

    @ApiModelProperty("0:修改时间modified，2:出入库时间io_date，未传入时默认为0")
    private Integer date_type;

    @ApiModelProperty("时间戳，sql server中的行版本号，该字段查询防止分页过程中漏单")
    private Long start_ts;

    @ApiModelProperty("货主编码（三方仓商家不传货主默认查自身数据，若查所有货主需传值：2147483647）")
    private Integer owner_co_id;
}
