package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 其它出入库上传请求参数
 * API: /open/jushuitan/otherinout/upload
 */
@Data
public class OtherInOutUploadRequest {

    @ApiModelProperty("是否确认单据；默认false")
    private Boolean is_confirm;

    @ApiModelProperty("是否审核单据；默认false")
    private Boolean excute_confirming;

    @ApiModelProperty("分仓编号或者三方仓编码")
    private Integer wms_co_id;

    @ApiModelProperty(value = "出入库类型:in是入库（其它退货）out是出库（其它出库）", required = true)
    private String type;

    @ApiModelProperty(value = "外部单号（单据上传成功之后对应页面线上单号）", required = true)
    private String external_id;

    @ApiModelProperty("默认1，主仓=1，销退仓=2，进货仓=3，次品仓=4，自定义1仓=6，自定义2仓=7，自定义3仓=8，自定义4仓=9，自定义5仓=10，自定义6仓=11，自定义7仓=12，自定义8仓=13，自定义9仓=14，自定义10仓=15")
    private Integer warehouse;

    @ApiModelProperty("备注，不能传空值")
    private String remark;

    @ApiModelProperty("出库类型")
    private String drp_co_name;

    @ApiModelProperty(value = "商品列表", required = true)
    private List<OtherInOutItem> items;

    @ApiModelProperty("收件人姓名")
    private String receiver_name;

    @ApiModelProperty("收件人手机号")
    private String receiver_mobile;

    @ApiModelProperty("收件地址省")
    private String receiver_state;

    @ApiModelProperty("收件地址市")
    private String receiver_city;

    @ApiModelProperty("收件地址区|县")
    private String receiver_district;

    @ApiModelProperty("收件详细地址")
    private String receiver_address;

    @ApiModelProperty("标记｜多标签（总length不能超过200）")
    private List<String> labels;

    @ApiModelProperty("虚拟仓编号(对应虚拟仓设置页面虚拟仓编号):传ID取ID，传名称取名称，二者皆传以ID为准")
    private Integer lock_wh_id;

    @ApiModelProperty("虚拟仓名称")
    private String lock_wh_name;

    @ApiModelProperty("物流公司编码")
    private String lc_id;

    @ApiModelProperty("物流单号")
    private String l_id;

    @ApiModelProperty("物流公司名称")
    private String logistics_company;

    @Data
    public static class OtherInOutItem {
        @ApiModelProperty(value = "商品编码", required = true)
        private String sku_id;

        @ApiModelProperty("唯一码集合（如需使用请在基础设置开启唯一码和序列号）")
        private List<String> sku_sns;

        @ApiModelProperty(value = "数量（必须大于0）", required = true)
        private Integer qty;

        @ApiModelProperty("内部供应商编码")
        private Long supplier_id;

        @ApiModelProperty("批次单号，系统中需开启相关配置")
        private String batch_id;

        @ApiModelProperty("生产日期，系统中需开启相关配置")
        private String produced_date;

        @ApiModelProperty("有效期至，系统中需开启相关配置")
        private String expiration_date;

        @ApiModelProperty("备注")
        private String remark;

        @ApiModelProperty("商品单价")
        private BigDecimal sale_price;

        @ApiModelProperty("成本价（最大4位小数，四舍五入，数值传空时，不传默认取商品资料成本价，最大值不得超过99999999）")
        private BigDecimal cost_price;
    }
}
