package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 库存盘点查询响应
 * API: /open/inventory/count/query
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InventoryCountQueryResponse extends JushuitanBaseResponse {

    private InventoryCountQueryData data;

    @Data
    public static class InventoryCountQueryData {
        private Integer page_size;
        private Integer page_index;
        private Integer data_count;
        private Integer page_count;
        private Boolean has_next;
        private List<InventoryCountData> datas;
    }

    @Data
    public static class InventoryCountData {
        private String type;
        private Integer io_id;
        private String io_date;
        private String status;
        private String warehouse;
        private String creator_name;
        private String remark;
        private Integer wh_id;
        private Integer wms_co_id;
        private String modified;
        private String f_status;
        private Integer lock_wh_id;
        private String lock_wh_name;
        private String labels;
        private List<InventoryCountItem> items;
        private List<BatchInfo> batchs;
    }

    @Data
    public static class InventoryCountItem {
        private Integer io_id;
        private Integer ioi_id;
        private String sku_id;
        private String i_id;
        private String name;
        private String properties_value;
        private Integer r_qty;
        private Integer qty;
        private String batch_id;
        private String product_date;
        private Integer supplier_id;
        private String expiration_date;
        private List<BatchInfo> batchs;
        private List<SnInfo> sns;
    }

    @Data
    public static class BatchInfo {
        private String batch_no;
        private String sku_id;
        private Integer qty;
        private String product_date;
        private Integer supplier_id;
        private String supplier_name;
        private String expiration_date;
        private String ioi_id;
    }

    @Data
    public static class SnInfo {
        private String sku_id;
        private String sn;
        private BigDecimal qty;
    }
}
