package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 其它出入库查询响应
 * API: /open/other/inout/query
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtherInOutQueryResponse extends JushuitanBaseResponse {

    private OtherInOutQueryData data;

    @Data
    public static class OtherInOutQueryData {
        private Integer page_size;
        private Integer page_index;
        private Integer data_count;
        private Integer page_count;
        private Boolean has_next;
        private List<OtherInOutData> datas;
    }

    @Data
    public static class OtherInOutData {
        private Integer io_id;
        private String io_date;
        private String status;
        private String so_id;
        private String type;
        private String f_status;
        private String warehouse;
        private String receiver_name;
        private String receiver_mobile;
        private String receiver_state;
        private String receiver_city;
        private String receiver_district;
        private String receiver_address;
        private Integer wh_id;
        private String remark;
        private String modified;
        private String created;
        private String labels;
        private Integer wms_co_id;
        private String creator_name;
        private Long wave_id;
        private String drop_co_name;
        private String inout_user;
        private String l_id;
        private String lc_id;
        private String logistics_company;
        private Integer lock_wh_id;
        private String lock_wh_name;
        private Integer supplier_id;
        private List<OtherInOutItem> items;
        private Long ts;
    }

    @Data
    public static class OtherInOutItem {
        private Integer ioi_id;
        private String sku_id;
        private String name;
        private String unit;
        private String properties_value;
        private Integer qty;
        private BigDecimal cost_price;
        private BigDecimal cost_amount;
        private String i_id;
        private String remark;
        private Integer io_id;
        private BigDecimal sale_price;
        private BigDecimal sale_amount;
        private String batch_id;
        private String product_date;
        private Integer supplier_id;
        private String expiration_date;
        private List<BatchInfo> batchs;
        private List<SnInfo> sns;
    }

    @Data
    public static class BatchInfo {
        private String batch_no;
        private String sku_id;
        private Integer qty;
        private String product_date;
        private Integer supplier_id;
        private String supplier_name;
        private String ioi_id;
    }

    @Data
    public static class SnInfo {
        private String sku_id;
        private String sn;
    }
}
