/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service.JstService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.AllocateUploadRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.InventoryCountQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.OtherInOutQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.OtherInOutUploadRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInAllotQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseReturnBatchRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.WarehouseQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.AllocateUploadResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.InventoryCountQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.OtherInOutQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.OtherInOutUploadResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchAllotResultDetailQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseOnboundQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.SupplierSyncResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.WarehouseQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitanService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class JushuitanServiceImpl
implements JushuitanService {
    private static final Logger log = LoggerFactory.getLogger(JushuitanServiceImpl.class);
    private final OutsidePushRecordRepository outsidePushRecordRepository;
    private final JstService jstService;

    @Override
    @Transactional
    public JushuitanBaseResponse createMaterial(UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        return this.createMaterial(null, null, null, request, pushRecordInterType, docId, docNo);
    }

    @Override
    @Transactional
    public JushuitanBaseResponse createMaterial(String appKey, String appSecret, String accessToken, UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getItems())) {
            String errorMsg = "createMaterial\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216items\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (request.getItems().size() > 1) {
            log.warn("createMaterial\u8bf7\u6c42\u5305\u542b{}\u4e2a\u5546\u54c1\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u4e2a\u5546\u54c1\u3002\u5efa\u8bae\u6bcf\u6b21\u8bf7\u6c42\u4ec5\u5305\u542b\u4e00\u4e2a\u5546\u54c1", (Object)request.getItems().size());
        }
        log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5546\u54c1ID: {}, \u8bf7\u6c42\u53c2\u6570: {}", (Object)request.getItems().get(0).getSkuId(), (Object)JSON.toJSONString((Object)request, (boolean)true));
        try {
            Map<String, Object> itemMap = this.buildItemMap(request);
            Map<String, List<Map<String, Object>>> requestMap = Collections.singletonMap("items", Collections.singletonList(itemMap));
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse response = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/jushuitan/itemsku/upload", OutsidePushInter.ITEM_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)response);
            if (response == null) {
                log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94\u4e3a\u7a7a");
                throw new RuntimeException("\u805a\u6c34\u6f6d\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u5546\u54c1ID: {}, \u54cd\u5e94\u72b6\u6001: {}", (Object)request.getItems().get(0).getSkuId(), (Object)"\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 | \u5546\u54c1ID: {}", (Object)request.getItems().get(0).getSkuId(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildItemMap(UpdateGoodsRequest request) {
        UpdateGoodsRequest.Item item = request.getItems().get(0);
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((Object)item.getSkuId()) || StringUtils.isEmpty((Object)item.getIId()) || StringUtils.isEmpty((Object)item.getName())) {
            throw new IllegalArgumentException(String.format("\u7269\u6599\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5931 | skuId: %s, iId: %s, name: %s", item.getSkuId(), item.getIId(), item.getName()));
        }
        itemMap.put("sku_id", item.getSkuId());
        itemMap.put("i_id", item.getIId());
        itemMap.put("name", item.getName());
        return itemMap;
    }

    @Override
    @Transactional
    public SupplierSyncResponse syncSupp(SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        return this.syncSupp(null, null, null, request, pushRecordInterType, docId, docNo);
    }

    @Override
    @Transactional
    public SupplierSyncResponse syncSupp(String appKey, String appSecret, String accessToken, SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getSuppliers())) {
            String errorMsg = "syncSupp\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216suppliers\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size());
        try {
            List failedSuppliers;
            List suppliers = request.getSuppliers().stream().map(this::buildSupplierItemMap).collect(Collectors.toList());
            String jsonRequest = JSON.toJSONString(suppliers);
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/supplier/upload", OutsidePushInter.SUPPORT_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            SupplierSyncResponse response = this.convertToSupplierSyncResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((SupplierSyncResponse.SupplierSyncData)response.getData()).getDatas()) && !(failedSuppliers = ((SupplierSyncResponse.SupplierSyncData)response.getData()).getDatas().stream().filter(data -> !Boolean.TRUE.equals(data.getIssuccess())).map(SupplierSyncResponse.SupplierData::getSupplier_code).collect(Collectors.toList())).isEmpty()) {
                log.warn("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u90e8\u5206\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 | \u5931\u8d25\u7684\u4f9b\u5e94\u5546\u7f16\u7801: {}", (Object)String.join((CharSequence)",", failedSuppliers));
            }
            log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u4f9b\u5e94\u5546\u6570\u91cf: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getSuppliers().size(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5f02\u5e38 | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private SupplierSyncResponse convertToSupplierSyncResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        SupplierSyncResponse response = new SupplierSyncResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                SupplierSyncResponse.SupplierSyncData supplierData = (SupplierSyncResponse.SupplierSyncData)JSON.parseObject((String)dataJson, SupplierSyncResponse.SupplierSyncData.class);
                response.setData(supplierData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u4f9b\u5e94\u5546\u540c\u6b65\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public PurchaseInboundResponse purchaseinCreatebatch(PurchaseInboundListRequest request, Long docId, String docNo) throws Exception {
        return this.purchaseinCreatebatch(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchaseInboundResponse purchaseinCreatebatch(String appKey, String appSecret, String accessToken, PurchaseInboundListRequest request, Long docId, String docNo) throws Exception {
        List failedMessage;
        if (request == null || CollectionUtils.isEmpty(request.getList())) {
            String errorMsg = "purchaseinCreatebatch\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216list\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)request.getList().size());
        String jsonRequest = JSON.toJSONString(request.getList());
        log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
        JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/webapi/wmsapi/purchasein/createbatch", OutsidePushInter.INV_IDO_SYNC_TO_JST.name(), docId, docNo);
        log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
        PurchaseInboundResponse response = JstService.convertToPurchaseInboundResponse(baseResponse);
        if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty((Collection)((Collection)response.getData())) && !(failedMessage = ((List)response.getData()).stream().filter(data -> !Boolean.TRUE.equals(data.getIs_success())).map(PurchaseInboundResponse.PurchaseInboundData::getMessage).collect(Collectors.toList())).isEmpty()) {
            log.warn("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u90e8\u5206\u5165\u5e93\u5355\u521b\u5efa\u5931\u8d25 | \u5931\u8d25\u7684\u5916\u90e8\u5355\u53f7: {}", (Object)String.join((CharSequence)",", failedMessage));
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u5165\u5e93\u5355\u6570\u91cf: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getList().size(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
        return response;
    }

    private PushRecordDTO buildPushRecordDTO(String interType, String docNo, Long docId) {
        PushRecordDTO dto = new PushRecordDTO();
        dto.setInterType(interType);
        dto.setDocNo("");
        dto.setDocId(Long.valueOf(0L));
        dto.setReqSuccess(false);
        return dto;
    }

    @Override
    @Transactional
    public WarehouseQueryResponse queryWarehouse(WarehouseQueryRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        return this.queryWarehouse(null, null, null, request, pushRecordInterType, docId, docNo);
    }

    @Override
    @Transactional
    public WarehouseQueryResponse queryWarehouse(String appKey, String appSecret, String accessToken, WarehouseQueryRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new WarehouseQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u9875\u7801: {}, \u9875\u5927\u5c0f: {}", (Object)request.getPage_index(), (Object)request.getPage_size());
        try {
            HashMap<String, Integer> requestMap = new HashMap<String, Integer>();
            if (request.getPage_index() != null) {
                requestMap.put("page_index", request.getPage_index());
            }
            if (request.getPage_size() != null) {
                requestMap.put("page_size", request.getPage_size());
            }
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/wms/partner/query", pushRecordInterType, docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            WarehouseQueryResponse response = this.convertToWarehouseQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u4ed3\u5e93\u6570\u91cf: {}", (Object)((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private WarehouseQueryResponse convertToWarehouseQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        WarehouseQueryResponse response = new WarehouseQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                WarehouseQueryResponse.WarehouseQueryData warehouseData = (WarehouseQueryResponse.WarehouseQueryData)JSON.parseObject((String)dataJson, WarehouseQueryResponse.WarehouseQueryData.class);
                response.setData(warehouseData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u4ed3\u5e93\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public PurchaseInboundQueryResponse queryPurchaseInbound(PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryPurchaseInbound(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchaseInboundQueryResponse queryPurchaseInbound(String appKey, String appSecret, String accessToken, PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new PurchaseInboundQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            Map<String, Object> requestMap = this.buildPurchaseInboundQueryParams(request);
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/webapi/wmsapi/purchasein/purchaseinquery", OutsidePushInter.JST_INV_IDO_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            PurchaseInboundQueryResponse response = this.convertToPurchaseInboundQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((PurchaseInboundQueryResponse.PurchaseInboundQueryData)response.getData()).getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)((PurchaseInboundQueryResponse.PurchaseInboundQueryData)response.getData()).getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildPurchaseInboundQueryParams(PurchaseInboundQueryRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (StringUtils.hasText((String)request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (StringUtils.hasText((String)request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (!CollectionUtils.isEmpty(request.getPo_ids())) {
            requestMap.put("po_ids", request.getPo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getStatuss())) {
            requestMap.put("statuss", request.getStatuss());
        }
        if (!CollectionUtils.isEmpty(request.getSo_ids())) {
            requestMap.put("so_ids", request.getSo_ids());
        }
        if (request.getStart_ts() != null) {
            requestMap.put("start_ts", request.getStart_ts());
        }
        if (request.getIs_get_total() != null) {
            requestMap.put("is_get_total", request.getIs_get_total());
        }
        if (request.getDate_type() != null) {
            requestMap.put("date_type", request.getDate_type());
        }
        if (!CollectionUtils.isEmpty(request.getSeller_ids())) {
            requestMap.put("seller_ids", request.getSeller_ids());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }
        return requestMap;
    }

    private PurchaseInboundQueryResponse convertToPurchaseInboundQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        PurchaseInboundQueryResponse response = new PurchaseInboundQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                PurchaseInboundQueryResponse.PurchaseInboundQueryData queryData = (PurchaseInboundQueryResponse.PurchaseInboundQueryData)JSON.parseObject((String)dataJson, PurchaseInboundQueryResponse.PurchaseInboundQueryData.class);
                response.setData(queryData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    private Map<String, Object> buildSupplierItemMap(SupplierRequest.SupplierItem item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplier_code", item.getSupplier_code());
        map.put("name", item.getName());
        map.put("enabled", true);
        return map;
    }

    @Override
    @Transactional
    public PurchaseInboundResponse purchaseinReturnbatch(PurchaseReturnBatchRequest request, Long docId, String docNo) throws Exception {
        return this.purchaseinReturnbatch(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchaseInboundResponse purchaseinReturnbatch(String appKey, String appSecret, String accessToken, PurchaseReturnBatchRequest request, Long docId, String docNo) throws Exception {
        List failedMessage;
        if (request == null || CollectionUtils.isEmpty(request.getList())) {
            String errorMsg = "purchaseinCreatebatch\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216list\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u9000\u8d27\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)request.getList().size());
        String jsonRequest = JSON.toJSONString(request.getList());
        log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u9000\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
        JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/webapi/wmsapi/purchaseout/createbatch", OutsidePushInter.INV_ODO_SYNC_TO_JST.name(), docId, docNo);
        log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u9000\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
        PurchaseInboundResponse response = JstService.convertToPurchaseInboundResponse(baseResponse);
        if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty((Collection)((Collection)response.getData())) && !(failedMessage = ((List)response.getData()).stream().filter(data -> !Boolean.TRUE.equals(data.getIs_success())).map(PurchaseInboundResponse.PurchaseInboundData::getMessage).collect(Collectors.toList())).isEmpty()) {
            log.warn("\u805a\u6c34\u6f6d\u91c7\u8d2d\u9000\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u90e8\u5206\u5165\u5e93\u5355\u521b\u5efa\u5931\u8d25 | \u5931\u8d25\u7684\u5916\u90e8\u5355\u53f7: {}", (Object)String.join((CharSequence)",", failedMessage));
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u9000\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u51fa\u5e93\u5355\u6570\u91cf: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getList().size(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
        return response;
    }

    @Override
    @Transactional
    public PurchaseOnboundQueryResponse queryPurchaseOnbound(PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryPurchaseOnbound(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchaseOnboundQueryResponse queryPurchaseOnbound(String appKey, String appSecret, String accessToken, PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new PurchaseInboundQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            Map<String, Object> requestMap = this.buildPurchaseOnboundQueryParams(request);
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/purchaseout/query", OutsidePushInter.JST_INV_ODO_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            PurchaseOnboundQueryResponse response = this.convertToPurchaseOnboundQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((PurchaseOnboundQueryResponse.PurchaseOnboundQueryData)response.getData()).getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)((PurchaseOnboundQueryResponse.PurchaseOnboundQueryData)response.getData()).getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3: " + e.getMessage(), e);
        }
    }

    private PurchaseOnboundQueryResponse convertToPurchaseOnboundQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        PurchaseOnboundQueryResponse response = new PurchaseOnboundQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                PurchaseOnboundQueryResponse.PurchaseOnboundQueryData queryData = (PurchaseOnboundQueryResponse.PurchaseOnboundQueryData)JSON.parseObject((String)dataJson, PurchaseOnboundQueryResponse.PurchaseOnboundQueryData.class);
                response.setData(queryData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    private Map<String, Object> buildPurchaseOnboundQueryParams(PurchaseInboundQueryRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (StringUtils.hasText((String)request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (StringUtils.hasText((String)request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (!CollectionUtils.isEmpty(request.getPo_ids())) {
            requestMap.put("po_ids", request.getPo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getStatuss())) {
            requestMap.put("statuss", request.getStatuss());
        }
        if (!CollectionUtils.isEmpty(request.getSo_ids())) {
            requestMap.put("so_ids", request.getSo_ids());
        }
        if (request.getStart_ts() != null) {
            requestMap.put("start_ts", request.getStart_ts());
        }
        if (request.getIs_get_total() != null) {
            requestMap.put("is_get_total", request.getIs_get_total());
        }
        if (request.getDate_type() != null) {
            requestMap.put("date_type", request.getDate_type());
        }
        if (!CollectionUtils.isEmpty(request.getSeller_ids())) {
            requestMap.put("seller_ids", request.getSeller_ids());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }
        return requestMap;
    }

    @Override
    @Transactional
    public AllocateUploadResponse allocateUpload(AllocateUploadRequest request, Long docId, String docNo) throws Exception {
        return this.allocateUpload(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public AllocateUploadResponse allocateUpload(String appKey, String appSecret, String accessToken, AllocateUploadRequest request, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getList())) {
            String errorMsg = "allocateUpload\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216list\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u8c03\u62e8\u5355\u6570\u91cf: {}", (Object)request.getList().size());
        try {
            String jsonRequest = JSON.toJSONString(request.getList());
            log.debug("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/allocate/kc/upload", OutsidePushInter.INV_ALLOCATE_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            AllocateUploadResponse response = this.convertToAllocateUploadResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(response.getData().getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u4e0a\u4f20\u6210\u529f | \u8c03\u62e8\u5355\u6570\u91cf: {}", (Object)response.getData().getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u4e0a\u4f20\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u8c03\u62e8\u5355\u6570\u91cf: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getList().size(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38 | \u8c03\u62e8\u5355\u6570\u91cf: {}", (Object)request.getList().size(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private AllocateUploadResponse convertToAllocateUploadResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        AllocateUploadResponse response = new AllocateUploadResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                AllocateUploadResponse.AllocateUploadData allocateData = (AllocateUploadResponse.AllocateUploadData)JSON.parseObject((String)dataJson, AllocateUploadResponse.AllocateUploadData.class);
                response.setData(allocateData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u5e93\u5b58\u8c03\u62e8\u4e0a\u4f20\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public PurchAllotResultDetailQueryResponse queryAllotPurchaseOnbound(PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryAllotPurchaseOnbound(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchAllotResultDetailQueryResponse queryAllotPurchaseOnbound(String appKey, String appSecret, String accessToken, PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new PurchaseInAllotQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            String jsonRequest = JSON.toJSONString((Object)request);
            log.debug("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/allocate/query", OutsidePushInter.JST_ALLOT_ODO_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            PurchAllotResultDetailQueryResponse response = this.convertToPurchAllotResultDetailQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(response.getData().getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)response.getData().getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u91c7\u8d2d\u51fa\u5e93\u67e5\u8be2\u63a5\u53e3: " + e.getMessage(), e);
        }
    }

    private PurchAllotResultDetailQueryResponse convertToPurchAllotResultDetailQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        PurchAllotResultDetailQueryResponse response = new PurchAllotResultDetailQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                PurchAllotResultDetailQueryResponse.AllocateQueryData queryData = (PurchAllotResultDetailQueryResponse.AllocateQueryData)JSON.parseObject((String)dataJson, PurchAllotResultDetailQueryResponse.AllocateQueryData.class);
                response.setData(queryData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u8c03\u62e8\u51fa\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public PurchAllotResultDetailQueryResponse queryAllotPurchaseInbound(PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryAllotPurchaseInbound(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public PurchAllotResultDetailQueryResponse queryAllotPurchaseInbound(String appKey, String appSecret, String accessToken, PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new PurchaseInAllotQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            String jsonRequest = JSON.toJSONString((Object)request);
            log.debug("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/allocate/query", OutsidePushInter.JST_ALLOT_IN_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            PurchAllotResultDetailQueryResponse response = this.convertToPurchAllotResultDetailQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(response.getData().getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)response.getData().getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u8c03\u62e8\u5165\u5e93\u67e5\u8be2\u63a5\u53e3: " + e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public OtherInOutUploadResponse otherInOutUpload(OtherInOutUploadRequest request, Long docId, String docNo) throws Exception {
        return this.otherInOutUpload(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public OtherInOutUploadResponse otherInOutUpload(String appKey, String appSecret, String accessToken, OtherInOutUploadRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            String errorMsg = "otherInOutUpload\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (StringUtils.isEmpty((Object)request.getType()) || StringUtils.isEmpty((Object)request.getExternal_id()) || CollectionUtils.isEmpty(request.getItems())) {
            String errorMsg = "otherInOutUpload\u5fc5\u586b\u53c2\u6570\u7f3a\u5931: type, external_id, items";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u7c7b\u578b: {}, \u5916\u90e8\u5355\u53f7: {}, \u5546\u54c1\u6570\u91cf: {}", new Object[]{request.getType(), request.getExternal_id(), request.getItems().size()});
        try {
            String jsonRequest = JSON.toJSONString((Object)request);
            log.debug("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/jushuitan/otherinout/upload", OutsidePushInter.OTHER_IN_OUT_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            OtherInOutUploadResponse response = this.convertToOtherInOutUploadResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null) {
                log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u4e0a\u4f20\u6210\u529f | \u5916\u90e8\u5355\u53f7: {}, \u7cfb\u7edf\u5355\u53f7: {}", (Object)response.getData().getExternal_id(), (Object)response.getData().getIo_id());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u4e0a\u4f20\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u7c7b\u578b: {}, \u5916\u90e8\u5355\u53f7: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getType(), request.getExternal_id(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38 | \u7c7b\u578b: {}, \u5916\u90e8\u5355\u53f7: {}", new Object[]{request.getType(), request.getExternal_id(), e});
            throw new Exception("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private OtherInOutUploadResponse convertToOtherInOutUploadResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        OtherInOutUploadResponse response = new OtherInOutUploadResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                OtherInOutUploadResponse.OtherInOutData otherInOutData = (OtherInOutUploadResponse.OtherInOutData)JSON.parseObject((String)dataJson, OtherInOutUploadResponse.OtherInOutData.class);
                response.setData(otherInOutData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u5176\u5b83\u51fa\u5165\u5e93\u4e0a\u4f20\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public OtherInOutQueryResponse queryOtherInOut(OtherInOutQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryOtherInOut(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public OtherInOutQueryResponse queryOtherInOut(String appKey, String appSecret, String accessToken, OtherInOutQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new OtherInOutQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            Map<String, Object> requestMap = this.buildOtherInOutQueryParams(request);
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/other/inout/query", OutsidePushInter.JST_FAIL_OUT_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            OtherInOutQueryResponse response = this.convertToOtherInOutQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(response.getData().getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u5355\u636e\u6570\u91cf: {}", (Object)response.getData().getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildOtherInOutQueryParams(OtherInOutQueryRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (StringUtils.hasText((String)request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (StringUtils.hasText((String)request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (!CollectionUtils.isEmpty(request.getSo_ids())) {
            requestMap.put("so_ids", request.getSo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getTypes())) {
            requestMap.put("types", request.getTypes());
        }
        if (StringUtils.hasText((String)request.getStatus())) {
            requestMap.put("status", request.getStatus());
        }
        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (request.getWms_co_id() != null) {
            requestMap.put("wms_co_id", request.getWms_co_id());
        }
        if (!CollectionUtils.isEmpty(request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (request.getDate_type() != null) {
            requestMap.put("date_type", request.getDate_type());
        }
        if (request.getStart_ts() != null) {
            requestMap.put("start_ts", request.getStart_ts());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }
        return requestMap;
    }

    private OtherInOutQueryResponse convertToOtherInOutQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        OtherInOutQueryResponse response = new OtherInOutQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                OtherInOutQueryResponse.OtherInOutQueryData queryData = (OtherInOutQueryResponse.OtherInOutQueryData)JSON.parseObject((String)dataJson, OtherInOutQueryResponse.OtherInOutQueryData.class);
                response.setData(queryData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u5176\u5b83\u51fa\u5165\u5e93\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public InventoryCountQueryResponse queryInventoryCount(InventoryCountQueryRequest request, Long docId, String docNo) throws Exception {
        return this.queryInventoryCount(null, null, null, request, docId, docNo);
    }

    @Override
    @Transactional
    public InventoryCountQueryResponse queryInventoryCount(String appKey, String appSecret, String accessToken, InventoryCountQueryRequest request, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new InventoryCountQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
        try {
            Map<String, Object> requestMap = this.buildInventoryCountQueryParams(request);
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(appKey, appSecret, accessToken, jsonRequest, "/open/inventory/count/query", OutsidePushInter.JST_INVENTORY_COUNT_RESULT_TO_SCM.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            InventoryCountQueryResponse response = this.convertToInventoryCountQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(response.getData().getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u76d8\u70b9\u5355\u6570\u91cf: {}", (Object)response.getData().getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildInventoryCountQueryParams(InventoryCountQueryRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (StringUtils.hasText((String)request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (StringUtils.hasText((String)request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (StringUtils.hasText((String)request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (StringUtils.hasText((String)request.getStatus())) {
            requestMap.put("status", request.getStatus());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }
        return requestMap;
    }

    private InventoryCountQueryResponse convertToInventoryCountQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        InventoryCountQueryResponse response = new InventoryCountQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                InventoryCountQueryResponse.InventoryCountQueryData queryData = (InventoryCountQueryResponse.InventoryCountQueryData)JSON.parseObject((String)dataJson, InventoryCountQueryResponse.InventoryCountQueryData.class);
                response.setData(queryData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u5e93\u5b58\u76d8\u70b9\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    public JushuitanServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository, JstService jstService) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
        this.jstService = jstService;
    }
}

