package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpallocateQuery;

import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

@Data
public class ErpStockAllocateQueryRequestBizData extends BaseRequestBizData {
    /**
     * 页码（默认0）
     */
    private Integer pageIndex;

    /**
     * 每页条数（默认50）
     */
    private Integer pageSize;

    /**
     * 调拨单状态（多个状态码逗号分隔，如：0,1,2）
     */
    private String status;

    /**
     * 创建时间起始（格式：yyyy-MM-dd HH:mm:ss）
     */
    private String startCreateTime;

    /**
     * 创建时间结束
     */
    private String endCreateTime;

    /**
     * 调入仓库编号（例：YC-0001）
     */
    private String inWarehouseCode;

    /**
     * 外部货品编号（支持批量：SKU-0001,SKU-0002）
     */
    private String outSkuCode;

    /**
     * 调出仓库编号（例：JYK-A）
     */
    private String outWarehouseCode;

    /**
     * 调拨单号（支持批量：DB2020120800000001,DB2020120800000002）
     */
    private String allocateNos;

    /**
     * 审核时间起始
     */
    private String auditDateStart;

    /**
     * 审核时间结束
     */
    private String auditDateEnd;

    /**
     * 修改时间起始
     */
    private String modifyStartDate;

    /**
     * 修改时间结束
     */
    private String modifyEndDate;

    /**
     * 入库状态（1:等待,2:部分,3:完成）
     */
    private String inStatus;

    /**
     * 出库状态（1:等待,2:部分,3:完成）
     */
    private String outStatus;

    /**
     * 来源单号（例：DB0000001）
     */
    private String sourceNo;

}
