package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout;



import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
/**
 * @description: 创建出库申请单并出库请求参数
 */
@Data
public class ErpStockCreateAndStockOutRequestBizData extends BaseRequestBizData {
	/**
	 * 供应商编码 
	 */ 
	private String vendCode;
	/**
	 * 仓库编码 
	 */ 
	private String outWarehouseCode;
	/**
	 * 出库类型 201-销售出库 202调拨出库 203 = 盘亏出库 204-其他出库 205采购退货 206生产领料 207组装拆卸出库 208翻新出库 209报废出库 210残次品出库 211倒冲出库 212 包材出库 215维修还厂 299可用库存修正 231成本调整出库 
	 */ 
	private Integer outType;
	/**
	 * 关联单据的id 
	 */ 
	private String relDataId;
	/**
	 * 申请人 
	 */ 
	private String applyUserName;
	/**
	 * 申请部门 
	 */ 
	private String applyDepartName;
	/**
	 * 申请时间 
	 */ 
	private Date applyDate;
	/**
	 * 备注 
	 */ 
	private String memo;
	/**
	 * 审核人 
	 */ 
	private String auditUserName;
	/**
	 * 审核时间 
	 */ 
	private Date auditDate;
	/**
	 * 通知状态编号 传0 控制不能创建单据 传100 可以直接出入库 
	 */ 
	private String notificationCode;
	/**
	 * 制单人 
	 */ 
	private String operator;
	/**
	 * 写死：OPEN 
	 */ 
	private String source;
	/**
	 * 标记Id集合 
	 */ 
	private String flagData;
	/**
	 * 预计出库时间 
	 */ 
	private Date planOutDate;
	/**
	 * 物流类型 
	 */ 
	private String logisticType;
	/**
	 * 物流单号 
	 */ 
	private String logisticNo;
	/**
	 * 物流公司编码 
	 */ 
	private String logisticCode;
	/**
	 * 物流公司名称 
	 */ 
	private String logisticName;
	/**
	 * 货品明细 
	 */ 
	private List<StockOutDetailViews> stockOutDetailViews;
	/**
	 * 收发货人信息 
	 */ 
	private StockOutExpressInfo stockOutExpressInfo;
	/**
	 * 公司编码 
	 */ 
	private String applyCompanyCode;
	/**
	 * 部门编码（需要确保传入公司下有对应部门） 
	 */ 
	private String applyDepartCode;
	/**
	 * 当收发件人省市区为空时,自动解析详情地址的省市区 
	 */ 
	private Integer isAutoResolutionAddress;
	/**
	 * 当收发件人的地址为空时,是否自动取仓库的地址 
	 */ 
	private Integer isSetFromWarehouse;
	/**
	 * 批次受仓库批次开关控制，若仓库不开启批次，则忽略传入的批次信息 （1 = 控制 ，0 或者 不传 =不控制 ） 
	 */ 
	private Byte batchControlByWarehouse;

	private BigDecimal currencyRate;

	private String currencyCode;

}

