package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * ClassName: JushuitanBaseResponse
 * Description: 聚水潭API基础响应参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
public class JushuitanBaseResponse<T> {

    @ApiModelProperty("响应编码，0表示成功，199表示调用频繁")
    private Integer code;

    @ApiModelProperty("响应消息")
    private String msg;

    @ApiModelProperty("请求ID")
    private String request_id;

    @ApiModelProperty("消息类型")
    private String msg_type;

    @ApiModelProperty("操作类型")
    private Integer act;
    //
    // @ApiModelProperty("Cookie信息")
    // private String cookie;

    @ApiModelProperty("响应数据")
    private T data;

    /**
     * 判断响应是否成功
     * @return true表示成功，false表示失败
     */
    public boolean isSuccess() {
        return code != null && code == 0;
    }

    /**
     * 判断是否调用频繁
     * @return true表示调用频繁，false表示正常
     */
    public boolean isTooFrequent() {
        return code != null && code == 199;
    }
}