package com.elitesland.zhiyuan.openapi.outer.nc.constants;

import lombok.Getter;

/**
 * nc 单据类型
 *
 * @author duwh
 * @date 2025/09/23
 */
@Getter
public enum NcBillTypeAndDataTypeEnums {

    MATERIAL("MATERIAL", "hd.vo.muap.pub.BillVO", "物料主档"),
    CUSTSUP("CUSTSUP", "hd.vo.muap.pub.BillVO", "客商主档"),
    SALEORDEROUT("SALEORDEROUT", "hd.vo.muap.pub.BillVO", "销售出库信息（包含退货）"),
    POORDERIN("POORDERIN", "hd.vo.muap.pub.BillVO", "采购订单"),
    GENERALOUT("GENERALOUT", "hd.vo.muap.pub.BillVO", "库存调整出库"),
    GENERALIN("GENERALIN", "hd.vo.muap.pub.BillVO", "库存调整入库"),
    SALEINVOICE("SALEINVOICE", "hd.vo.muap.pub.BillVO", "销售开票申请"),
    POINVOICE("POINVOICE", "hd.vo.muap.pub.BillVO", "采购开票")


    ;

    /**
     * 单据类型 固定值，根据不同的业务固定不同的值
     */
    private String billType;
    /**
     * 数据类型 固定值，根据接口约定传递
     */
    private String dataType;

    private String desc;


    NcBillTypeAndDataTypeEnums(String billType, String dataType, String desc) {
        this.billType = billType;
        this.dataType = dataType;
        this.desc = desc;
    }


}
