/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.GikyCloudResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.result.GikyCloudResult;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class JackyunServiceImpl
implements JackyunService {
    private static final Logger log = LoggerFactory.getLogger(JackyunServiceImpl.class);
    @Autowired
    private GikyCloudClient gikyCloudClient;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getGoodsNo())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u7f16\u7801 goodsNo \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)request.getGoodsName())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u540d\u79f0 goodsName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> bizData = new HashMap<String, String>();
        bizData.put("goodsNo", request.getGoodsNo());
        bizData.put("goodsName", request.getGoodsName());
        bizData.put("unitName", request.getUnitName());
        bizData.put("outSkuCode", request.getGoodsNo());
        if (StringUtils.isNotBlank((CharSequence)request.getGoodsNameEn())) {
            bizData.put("goodsNameEn", request.getGoodsNameEn());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSkuBarcode())) {
            bizData.put("skuBarcode", request.getSkuBarcode());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDescript())) {
            bizData.put("description", request.getDescript());
        }
        return this.parseGikyResponse(this.gikyCloudClient.post("erp.material.create.v2", "v1.0", null, bizData));
    }

    private String parseGikyResponse(String responseStr) throws Exception {
        GikyCloudResult result = this.getGikyCloudResult(responseStr);
        Map<String, Object> data = result.getData();
        String materialId = (String)data.get("materialId");
        if (materialId == null) {
            throw new RuntimeException("\u5409\u5ba2\u4e91\u8fd4\u56de\u7ed3\u679c\u7f3a\u5c11\u7269\u6599ID");
        }
        return materialId;
    }

    @Override
    @Transactional
    public String createVendor(VendCreateRequest request) throws Exception {
        request.validate();
        HashMap<String, String> bizData = new HashMap<String, String>();
        bizData.put("code", request.getCode());
        bizData.put("name", request.getName());
        return this.parseSuppGikyResponse(this.gikyCloudClient.post("erp.vend.create.v2", "v1.0", null, bizData));
    }

    private String parseSuppGikyResponse(String responseStr) throws Exception {
        GikyCloudResult result = this.getGikyCloudResult(responseStr);
        Map<String, Object> data = result.getData();
        String vendId = (String)data.get("vendId");
        if (vendId == null) {
            throw new RuntimeException("\u5409\u5ba2\u4e91\u8fd4\u56de\u7ed3\u679c\u7f3a\u5c11\u4f9b\u5e94\u5546ID");
        }
        return vendId;
    }

    private GikyCloudResult getGikyCloudResult(String responseStr) throws Exception {
        GikyCloudResponse response = (GikyCloudResponse)this.objectMapper.readValue(responseStr, this.objectMapper.getTypeFactory().constructParametricType(GikyCloudResponse.class, new Class[]{GikyCloudResult.class}));
        if (response.getCode() != 200) {
            throw new RuntimeException("\u5409\u5ba2\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25: " + response.getMsg() + " (subCode: " + response.getSubCode() + ")");
        }
        GikyCloudResult result = (GikyCloudResult)response.getResult();
        if (result == null || result.getData() == null) {
            throw new RuntimeException("\u5409\u5ba2\u4e91\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        return result;
    }
}

