package com.gb.soa.omp.cuniversal.listener;

import com.gb.soa.omp.ccommon.api.annotation.EnhanceRequestMapping;
import com.gb.soa.omp.ccommon.util.JsonUtil;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: wanwenfeng
 * @Date: 2021/5/10 11:43
 * @Description:
 */
@Component
public class ContextRefreshedListener implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private WebApplicationContext webApplicationContext;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        // 根容器为Spring容器
        System.out.println(JsonUtil.toJson(event.getApplicationContext().getBeansWithAnnotation(EnhanceRequestMapping.class)));
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(EnhanceRequestMapping.class);
        if (CollectionUtils.isEmptyMap(beans)) {
            return;
        }
        RequestMappingHandlerMapping requestMappingHandlerMapping = webApplicationContext.getBean(RequestMappingHandlerMapping.class);
        beans.forEach((serviceName, handler) -> {
            Class<?> handlerType = (handler instanceof String) ?
                    event.getApplicationContext().getType((String) handler) : handler.getClass();

            Class[] interfaces = ClassUtils.getUserClass(handlerType).getInterfaces();
            Class<?> userType = null;
            if (!this.arrayIsEmpty(interfaces)) {
                for (Class anInterface : interfaces) {
                    String interfaceName = captureName(serviceName);
                    if (interfaceName.equals(anInterface.getSimpleName())) {
                        userType = anInterface;
                    }
                }
            }
            if (Objects.isNull(userType)) {
                return;
            }

            List<Method> methods = Arrays.asList(userType.getDeclaredMethods());
            EnhanceRequestMapping typeAnnotation = AnnotationUtils.findAnnotation(userType,
                    EnhanceRequestMapping.class);
            String[] oldValue = this.arrayIsEmpty(typeAnnotation.value()) ? new String[]{userType.getName()} : typeAnnotation.value();
            for (Method method : methods) {
                //根据方法上的@RequestMapping来创建RequestMappingInfo实例。
                String[] newValues = new String[oldValue.length];
                for (int i = 0; i < oldValue.length; i++) {
                    newValues[i] = oldValue[i].concat(".").concat(method.getName());
                }
                PatternsRequestCondition patternsRequestCondition = new PatternsRequestCondition(newValues);
                RequestMethodsRequestCondition requestMethodsRequestCondition = new RequestMethodsRequestCondition(RequestMethod.GET, RequestMethod.POST);
                RequestMappingInfo requestMappingInfo = new RequestMappingInfo(patternsRequestCondition, requestMethodsRequestCondition, null, null, null, null, null);

                requestMappingHandlerMapping.registerMapping(requestMappingInfo, handler, method);
            }
        });
    }

    private boolean arrayIsEmpty(Object[] array) {
        return null == array || array.length == 0;
    }

    private String captureName(String name) {
        //name = name.substring(0, 1).toUpperCase() + name.substring(1);
        //return  name;
        char[] cs = name.toCharArray();
        cs[0] -= 32;
        return String.valueOf(cs);
    }
}
