package com.gb.soa.omp.cuniversal.service.impl;

import com.gb.soa.omp.ccommon.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gb.soa.omp.ccommon.api.exception.DatabaseOperateException;
import com.gb.soa.omp.ccommon.api.exception.ExceptionType;
import com.gb.soa.omp.ccommon.api.exception.ValidateBusinessException;
import com.gb.soa.omp.ccommon.util.ExceptionUtil;
import com.gb.soa.omp.ccommon.util.JsonMapper;
import com.gb.soa.omp.ccommon.util.StringUtil;
import com.gb.soa.omp.cuniversal.api.request.SystemLiveDetectRequest;
import com.gb.soa.omp.cuniversal.api.response.SystemLiveDetectResponse;
import com.gb.soa.omp.cuniversal.api.service.UniversalLiveDetectService;
import com.gb.soa.omp.cuniversal.util.UniversalLiveDetectUtil;

public class UniversalLiveDetectServiceImpl implements UniversalLiveDetectService {
	private static Logger log = LoggerFactory.getLogger(UniversalLiveDetectServiceImpl.class);

	
	//探测系统是否活着
	public SystemLiveDetectResponse detectSystemLive(SystemLiveDetectRequest request){
		if (log.isDebugEnabled()) {
			log.debug("begin detectSystemLive request:{}", JsonUtil.toJson(request));
		}
		SystemLiveDetectResponse response = new SystemLiveDetectResponse();
		try {
			request.validate("cbaseinfo",ExceptionType.VCE10007);
			if (!"none".equals(UniversalLiveDetectUtil.dbType)){
		        if(UniversalLiveDetectUtil.jdbcTemplate==null){
		        	throw new ValidateBusinessException("cbaseinfo",ExceptionType.VBE20007, "当前业务项目没有初始化JDBC,无法探测系统:"+request.getSubSystem()+"是否存活！");
		        }
		        String sql;
		        if ("oracle".equals(UniversalLiveDetectUtil.dbType)){
		        	sql="select 1 from dual";
		        } else if ("mysql".equals(UniversalLiveDetectUtil.dbType)){
		        	sql="select 'abc' ";
		        } else {
		        	throw new ValidateBusinessException("cbaseinfo",ExceptionType.VBE20007, "不支持数据库类别:"+UniversalLiveDetectUtil.dbType+",无法探测系统:"+request.getSubSystem()+"是否存活！");
		        }
		        String str=UniversalLiveDetectUtil.jdbcTemplate.queryForObject(sql,String.class);
				if (!StringUtil.isAllNullOrBlank(str)) {
				} else{
					response.setCode(ExceptionType.BE40144.getCode());
					response.setMessage("探测系统:"+request.getSubSystem()+"时发现系统停止！");
				}
			}
		} catch (Exception e) {
			ExceptionUtil.processException(e, response);
		}
		if (log.isDebugEnabled()) {
			log.debug("end detectSystemLive response:{}", response.toLowerCaseJson());
		}
		return response;
	}
	
}
