package com.gb.soa.omp.cuniversal.service.impl;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.util.JsonUtil;
import io.swagger.annotations.ApiModelProperty;
import com.gb.soa.omp.ccommon.api.exception.ExceptionType;
import com.gb.soa.omp.ccommon.api.exception.ValidateClientException;
import com.gb.soa.omp.ccommon.util.ExceptionUtil;
import com.gb.soa.omp.ccommon.util.JsonMapper;
import com.gb.soa.omp.cuniversal.api.model.MethodDocument;
import com.gb.soa.omp.cuniversal.api.request.MethodDocumentGetRequest;
import com.gb.soa.omp.cuniversal.api.response.MethodDocumentGetResponse;
import com.gb.soa.omp.cuniversal.api.service.UniversalSystemDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @auther: wenfeng
 * @date: 2020/9/25 13:56
 */
@Service("universalSystemDocumentService")
@RestController
public class UniversalSystemDocumentServiceImpl implements UniversalSystemDocumentService {
    private static Logger log = LoggerFactory.getLogger(UniversalSystemDocumentServiceImpl.class);

    private static List<String> filterType = Arrays.asList(new String[]{
            "string",
            "int",
            "integer",
            "long",
            "short",
            "bype",
            "float",
            "double",
            "boolean",
            "date",
            "bigdecimal",
            "character",
            "localdatetime",
            "localdate",
            "localtime",
    });

    private static List<String> filterField = Arrays.asList(new String[]{
            "serialVersionUID",
//            "tenantNumId",
//            "dataSign",
            "messageSeries",
            "EXCEPTION",
            "fullMessage",
            "OK",
            "checkRepeatSign",
            "requestNumId",
            "exposeMethod",
            "appkey",
    });

    @Override
    public MethodDocumentGetResponse getMethodDocument(MethodDocumentGetRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("begin getMethodDocument request:{}", JsonUtil.toJson(request));
        }

        MethodDocumentGetResponse response = new MethodDocumentGetResponse();
        try {
            Class clazz = Class.forName(request.getServicePath());
            if (Objects.isNull(clazz)) {
                throw new ValidateClientException("uninersal", ExceptionType.VCE10001, "未授权ip访问！");
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getName().equals(request.getMethod())) {
                    Class[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length > 0) {
                        List<MethodDocument> methodDocuments = this.getObjectClassInfo(parameterTypes[0], new ArrayList<String>());
                        response.setRequestDocuments(methodDocuments);
                    }
                    response.setResponseDocuments(this.getObjectClassInfo(method.getReturnType(), new ArrayList<String>()));
                }
            }

        } catch (Throwable e) {
            ExceptionUtil.processException(e, response);
        }
        if (log.isDebugEnabled()) {
            log.debug("end getMethodDocument response:{}", response.toLowerCaseJson());
        }
        return response;
    }

    private MethodDocument getObjectFileInfo(Field field, List<String> classList) {
        MethodDocument methodDocument = new MethodDocument();
        Class fieldType = field.getType();
        Class genericType = getGenericType(field);
        String fieldName = fieldType.getSimpleName();
        if (fieldType.isAssignableFrom(List.class)) {
            fieldName = fieldName.concat("<").concat(genericType.getSimpleName()).concat(">");
        }
        methodDocument.setFieldName(this.humpToLine(field.getName()));
        methodDocument.setFieldType(fieldName);
        if (field.isAnnotationPresent(ApiField.class)) {
            ApiField annotation = field.getAnnotation(ApiField.class);
            methodDocument.setDescription(annotation.description());
            methodDocument.setRequired(annotation.required());
            methodDocument.setExmple(annotation.exmple());
        } else if (field.isAnnotationPresent(ApiModelProperty.class)) {
            ApiModelProperty annotation = field.getAnnotation(ApiModelProperty.class);
            methodDocument.setDescription(annotation.value());
            methodDocument.setRequired(annotation.required());
            methodDocument.setExmple(annotation.example());
        }

        if (!filterType.contains(genericType.getSimpleName().toLowerCase()) && !classList.contains(genericType.getTypeName())) {

            List<MethodDocument> methodDocuments = this.getObjectClassInfo(genericType, classList);
            methodDocument.setFieldDocuments(methodDocuments);
        }
        return methodDocument;
    }

    private Class getGenericType(Field field) {
        Class clazz = field.getType();
        if (clazz.isAssignableFrom(List.class)) {
            // 当前集合的泛型类型
            Type genericType = field.getGenericType();
            if (null == genericType) {
                return clazz;
            }

            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType) genericType;
                // 得到泛型里的class类型对象
                clazz = (Class<?>) pt.getActualTypeArguments()[0];
            }
        }
        return clazz;
    }

    private List<MethodDocument> getObjectClassInfo(Class clazz, List<String> classList) {
        classList.add(clazz.getTypeName());
        List<MethodDocument> methodDocuments = new ArrayList<>();
        for (Field field : clazz.getDeclaredFields()) {
            if(!filterField.contains(field.getName())){
                methodDocuments.add(this.getObjectFileInfo(field, classList));
            }
        }
//        && !clazz.getSuperclass().getSimpleName().equals("AbstractRequest")
        if (null != clazz.getSuperclass() && !clazz.getSuperclass().equals(Object.class)) {
            methodDocuments.addAll(0,this.getObjectClassInfo(clazz.getSuperclass(), classList));
        }
        return methodDocuments;
    }


    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    private static String humpToLine(String str) {
        if(str.equals(str.toUpperCase())){
            return str;
        }else{
            Matcher matcher = humpPattern.matcher(str);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }


}
