package com.gb.soa.omp.cuniversal.util;

import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import com.gb.soa.omp.ccommon.api.exception.ExceptionType;
import com.gb.soa.omp.ccommon.api.exception.ValidateBusinessException;
import com.gb.soa.omp.ccommon.util.StringUtil;

@Component()
@Lazy(false)
public class UniversalLiveDetectUtil {

    public static JdbcTemplate jdbcTemplate;

    public static String dbType;

    //默认的dbType=none
    public static void initSystemLiveDetect(String dbTypeParam,String subSystemParam,JdbcTemplate jdbcTemplateClient) {
        if  (StringUtil.isAllNullOrBlank(dbTypeParam)){
            throw new ValidateBusinessException("cbaseinfo",ExceptionType.VBE20007, "dbType不能为空！");
        }
        if  (StringUtil.isAllNullOrBlank(subSystemParam)){
            throw new ValidateBusinessException("cbaseinfo",ExceptionType.VBE20007, "subSystem不能为空！");
        }
        if (!"mysql".equals(dbTypeParam) && !"oracle".equals(dbTypeParam) && !"none".equals(dbTypeParam) ) {
            throw new ValidateBusinessException("cbaseinfo",ExceptionType.VBE20007, "不支持的数据库类别:"+dbTypeParam);
        }
        jdbcTemplate = jdbcTemplateClient;
        dbType=dbTypeParam;
    }

  }
