package com.gb.soa.sequence.exception;

import java.util.HashMap;
import java.util.Map;

import com.gb.soa.omp.ccommon.api.exception.AbstractExceptionType;
import com.gb.soa.omp.ccommon.api.exception.ExceptionTypeCategory;

public class SequenceExceptionType extends AbstractExceptionType {
	public static SequenceExceptionType VCE10001 = new SequenceExceptionType(-10001, ExceptionTypeCategory.VALIDATE_CLIENT_EXCEPTION, SubSystem.SEQUENCE_CLIENT, "没有找到对应配置!");

	public static SequenceExceptionType INSTANCE = VCE10001;

	// 构造方法
	private SequenceExceptionType(long code, ExceptionTypeCategory category, String subSystem, String description) {
		super(code, category, subSystem, description);
	}

	private static class SubSystem {
		public static String SEQUENCE_CLIENT = "sequence_client";//
	}

	private static final Map<Long, AbstractExceptionType> lookup = new HashMap<Long, AbstractExceptionType>();
	static {
		lookup.put(VCE10001.getCode(), VCE10001);
	}

	public AbstractExceptionType getAbstractExceptionTypeByCode(long code) {
		AbstractExceptionType et = lookup.get(code);
		if (et == null) {
			throw new RuntimeException("不存在异常编号:" + code);
		}
		return et;
	}

}
