package com.gb.soa.sequence.service;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.nacos.api.config.listener.Listener;
import com.gb.soa.sequence.exception.SequenceException;
import com.gb.soa.sequence.util.DubboImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class IniteSequenceConfigService {

    protected static Logger logger = LoggerFactory.getLogger(IniteSequenceConfigService.class);

    public static String seqFilePath;

    public static ExecutorService executor;

    @Deprecated
    public void initSequenceConfig() throws SequenceException {
        try {
            // 加载 springcloud dubbo
            SequenceCliActionService.setSequenceActionService((SequenceActionService) DubboImpl.initDubboForSpringcloud(null));
            // 初始化锁对象
            SequenceCliActionService.locklists = new ArrayList<Object>();
            for (int i = 0; i < 50; i++) {
                SequenceCliActionService.locklists.add(new Object());
            }
            clearSequenceMap();
            buildThreadPool();

        } catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SequenceException(ex.getMessage());
        }

    }


    public void initSequenceConfig(NacosConfigManager nacosConfigManager) throws SequenceException {

        try {
            NacosConfigProperties nacosConfigProperties = nacosConfigManager.getNacosConfigProperties();
            String serverAddr = nacosConfigProperties.getServerAddr();
            String config = nacosConfigManager.getConfigService().getConfig("env-config.yml", "DEFAULT_GROUP", 5000);
            Yaml yaml = new Yaml();
            JSONObject jsonObject = yaml.loadAs(config, JSONObject.class);
            String registryUrl = jsonObject
                    .getJSONObject("dubbo")
                    .getJSONObject("registry")
                    .getString("address");
            registryUrl = registryUrl.replace("${spring.cloud.nacos.server-addr}", serverAddr);

            Map<String, String> registryParameters = jsonObject.getJSONObject("dubbo").getJSONObject("registry").getObject("parameters", new TypeReference<Map<String, String>>(){});

            // 加载 springcloud dubbo
            SequenceCliActionService.setSequenceActionService((SequenceActionService) DubboImpl.initDubboForSpringcloud(registryUrl, registryParameters));
            //注册监听
            nacosConfigManager.getConfigService().addListener("sequence-time.yml", "DEFAULT_GROUP", new Listener() {
                @Override
                public void receiveConfigInfo(String configInfo) {
                    System.out.println("recieve nacos sequence time change:" + configInfo);
                    IniteSequenceConfigService.clearSequenceMap();
                }

                @Override
                public Executor getExecutor() {
                    return null;
                }
            });
            // 初始化锁对象
            SequenceCliActionService.locklists = new ArrayList<Object>();
            for (int i = 0; i < 50; i++) {
                SequenceCliActionService.locklists.add(new Object());
            }
            clearSequenceMap();
            buildThreadPool();

        } catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SequenceException(ex.getMessage());
        }

    }


    public static void clearSequenceMap() {
        SequenceCliActionService.sequenceObjMap.clear();
        SequenceCliActionService.seqValueMap.clear();
        SequenceCliActionService.seqStoreStatusMap.clear();
    }

    private void buildThreadPool() {
        BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, queue);
        executor = threadPool;
    }

}
