package com.gb.soa.sequence.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gb.soa.omp.ccommon.util.JsonMapper;
import com.gb.soa.sequence.exception.SequenceException;
import com.gb.soa.sequence.model.CreateSequence;
import com.gb.soa.sequence.util.Constant;
import com.gb.soa.sequence.util.PropertiesUtil;
import com.gb.soa.sequence.util.SeqStringUtils;

import net.sf.json.JSONObject;

public class SequenceCliActionService {

	private static JsonMapper mapper = JsonMapper.nonDefaultMapper();

	static {
		mapper = JsonMapper.nonEmptyMapper();
		mapper.getMapper().setPropertyNamingStrategy(PropertyNamingStrategy.LowerCaseStrategy.SNAKE_CASE);
	}

	private static SequenceActionService sequenceActionService;

	protected static Logger logger = LoggerFactory.getLogger(SequenceCliActionService.class);

	public static Map<String, List<CreateSequence>> sequenceObjMap = new ConcurrentHashMap<String, List<CreateSequence>>();

	public static List<Object> locklists = new ArrayList<Object>();

	public static Map<String, List<Integer>> seqValueMap = new ConcurrentHashMap<String, List<Integer>>();

	// map序列存储方式
	public static Map<String, Integer> seqStoreStatusMap = new ConcurrentHashMap<String, Integer>();

	/**
	 * 调用服务端序列
	 */
	public CreateSequence getSequenceFromClient(String sysName, String seqName) {
		try {
			CreateSequence createSequence = new CreateSequence();
			createSequence.setSeqProject(sysName);
			createSequence.setSeqName(seqName);
			return sequenceActionService.getSequenceToClient(createSequence);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("获取服务器序列失败" + e.getMessage());
		}
	}

	/**
	 * 查询数据库对象，currentnum没有+1
	 * 
	 * @param seqName
	 * @return
	 * @author changhong.deng
	 * @date 2018年1月23日上午9:46:47
	 * @return List<CreateSequence>
	 */
	public List<CreateSequence> getSequenceModel(String seqName) {

		try {
			CreateSequence createSequence = new CreateSequence();
			createSequence.setSeqName(seqName);
			return sequenceActionService.getSequenceModelToClientCheck(createSequence);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("查询数据库异常!" + e.getMessage());
		}
	}

	// 获取序列存储的状态
	public Long getSequence(String systemName, String seqName) {
		// 存入map中
		Integer storeStatus = seqStoreStatusMap.get(seqName);
		if (null == storeStatus || storeStatus.equals("")) {
			storeStatus = sequenceActionService.getSeqStoreStatus(seqName);
			if (null == storeStatus) {
				throw new SequenceException("序列号【" + seqName + "】在配置表中不存在");
			} else {
				seqStoreStatusMap.put(seqName, storeStatus);
			}
		}

		Long seqNum = 0L;
		if (storeStatus == 0) {// 存内存
			seqNum = getStoreNotSequence(systemName, seqName);
		} else {// 存本地
			seqNum = getStoreLocalSequence(systemName, seqName);
		}
		if (seqNum == null) {
			SequenceCliActionService.sequenceObjMap.clear();
			SequenceCliActionService.seqValueMap.clear();
		}
		return seqNum;
	}

	/**
	 * 存内存序列号
	 * 
	 * @param systemName
	 * @param seqName
	 * @return
	 * @author changhong.deng
	 * @date 2018年1月18日下午2:52:16
	 * @return Long
	 */
	public Long getStoreNotSequence(String systemName, String seqName) {
		Long seqNum = null;
		String maxNum = "";
		String maxVal = "";
		String currentNum = "";
		String dateTime = "";
		String proFix = "";// 前缀
		String mapKey = seqName;
		Long disrupt = 0L;// 是否打乱 0：否 ，1 是
		List<CreateSequence> crelist = null;
		try {
			if (locklists.size() <= 0) {
				//throw new SequenceException("未初始化zk");
				throw new SequenceException("未初始化序列号内存锁!");
			}
			synchronized (locklists.get(Math.abs(seqName.hashCode()) % locklists.size())) {
				if (null == sequenceObjMap.get(mapKey)) {
					getSequenceToMap(systemName, seqName, "", null, "");
				}
				crelist = sequenceObjMap.get(mapKey);
				if (crelist.size() <= 0) {
					throw new SequenceException("调用服务端序列失败");
				}
				if (crelist.size() > 0 && null != crelist.get(0)) {
					maxNum = crelist.get(0).getSeqNum();
					maxVal = crelist.get(0).getSeqVal();
					currentNum = crelist.get(0).getCurrentNum().toString();// 当前num
					proFix = crelist.get(0).getSeqPrefix();
					dateTime = crelist.get(0).getSquenceTime();
					Integer currentSeqVal = crelist.get(0).getCurrentSeqVal();
					disrupt = crelist.get(0).getDisrupt();
					if (disrupt == 1L) {
						// 获取打乱的序列
						seqNum = disruptSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal, systemName,
								seqName, crelist);
					} else {
						seqNum = normalSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal, systemName,
								seqName, crelist);
					}

				}
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("获取序列失败,序列号的名称为：" + seqName + " ===" + e.getMessage());
		}
		return seqNum;
	}

	/**
	 * 打乱的序列
	 * 
	 * @author changhong.deng
	 * @date 2018年6月19日
	 */
	private Long disruptSeqNum(String maxNum, String maxVal, String currentNum, String dateTime, String proFix,
			Integer currentSeqVal, String systemName, String seqName, List<CreateSequence> crelist) {
		String key = seqName.trim();
		List<Integer> seqValueList = seqValueMap.get(key);
		if (null == seqValueList || seqValueList.size() <= 0) {

			seqValueList = SeqStringUtils.createSolution(Integer.valueOf(maxVal));
			seqValueMap.put(key, seqValueList);
		}
		if (currentSeqVal == null) {
			currentSeqVal = 0;
		}
		// 当序列号获取到三分之一时，再去服务器获取下一个新的序列
		if (currentSeqVal == Integer.valueOf(maxVal) / 3) {
			// 多线程
			IniteSequenceConfigService.executor.submit(new Runnable() {
				@Override
				public void run() {
					getSequenceToMap(systemName, seqName, "", null, "");
				}
			});

		}
		// 组装打乱的序列
		Long seqNum = installSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal, seqValueList);
		if (currentSeqVal >= Integer.valueOf(maxVal) - 1) {
			crelist.remove(crelist.get(0));
			seqValueMap.remove(key);
			if (crelist.size() <= 0) {
				getSequenceToMap(systemName, seqName, "", null, "");
			}
		} else {
			crelist.get(0).setCurrentSeqVal(currentSeqVal + 1);
		}

		return seqNum;
	}

	/**
	 * 组装打乱的序列号
	 * 
	 * @author changhong.deng
	 * @date 2018年6月19日
	 */
	private Long installSeqNum(String maxNum, String maxVal, String currentNum, String dateTime, String proFix,
			Integer currentSeqVal, List<Integer> seqValueList) {

		// 最终当前序列
		String resultVal = SeqStringUtils.frontCompWithZore(Long.valueOf(seqValueList.get(currentSeqVal)),
				maxVal.length());// vvvv
		// 将时间分离
		String[] split = dateTime.split("-");
		String year = dateTime.substring(2, split[0].length());
		String month = split[1];
		Integer day = Integer.valueOf(split[2]);
		String currentSeqNum = SeqStringUtils.getSquByNum(maxNum, currentNum);
		List<String> dayList = new ArrayList<String>();
		dayList.add(SeqStringUtils.frontCompWithZore(Long.valueOf(day), 2));
		dayList.add(SeqStringUtils.frontCompWithZore(Long.valueOf(day + Constant.DAY_NUM), 2));
		dayList.add(SeqStringUtils.frontCompWithZore(Long.valueOf(day + Constant.DAY_NUM * 2), 2));
		String resultDay = SeqStringUtils.getRandomNum(dayList);// dd

		// ==============组装开始===================

		char[] chYear = year.toCharArray();// 年//YY
		char[] chMonth = month.toCharArray();// 月//MM
		char[] chDay = resultDay.toCharArray();// 日/DD
		char[] chNum = currentSeqNum.toCharArray();// currentSeqNum//NNN
		char[] chVal = resultVal.toCharArray();// currentVal/vvvv
		int chVallen = chVal.length;
		int chNumlen = chNum.length;
		// 序列号顺序为：V1D80V6D01V6V=====YVDYMVMD NNVNV
		StringBuffer buff = new StringBuffer();
		buff.append(proFix.trim());
		buff.append(chYear[0]);// Y
		if (chVallen >= 1) {// V
			buff.append(chVal[0]);
		}
		buff.append(chDay[0]);// D
		buff.append(chYear[1]);// Y
		buff.append(chMonth[0]);// M
		if (chVallen >= 2) {// V
			buff.append(chVal[1]);
		}
		buff.append(chMonth[1]);// M
		buff.append(chDay[1]);// D
		if (chNumlen >= 1) {// N
			buff.append(chNum[0]);
		}
		if (chNumlen >= 2) {// N
			buff.append(chNum[1]);
		}
		if (chVallen >= 3) {// V
			buff.append(chVal[2]);
		}
		if (chNumlen >= 3) {// N
			buff.append(chNum[2]);
		}
		if (chVallen >= 4) {// V
			buff.append(chVal[3]);
		}
		if (chNumlen >= 4) {// N
			buff.append(chNum[3]);
		}
		if (chVallen >= 5) {// V
			buff.append(chVal[4]);
		}
		if (chNumlen >= 5) {// N
			buff.append(chNum[4]);
		}
		if (chVallen >= 6) {// V
			buff.append(chVal[5]);
		}
		if (chNumlen >= 6) {// N
			buff.append(chNum[5]);
		}
		return Long.valueOf(buff.toString());

	}

	/**
	 * 获取正常序列
	 * 
	 * @author changhong.deng
	 * @date 2018年6月19日
	 */
	private Long normalSeqNum(String maxNum, String maxVal, String currentNum, String dateTime, String proFix,
			Integer currentSeqVal, String systemName, String seqName, List<CreateSequence> crelist) {
		if (currentSeqVal == null) {
			currentSeqVal = 1;
		}

		// 当序列号获取到三分之一时，再去服务器获取下一个新的序列
		if (currentSeqVal == Integer.valueOf(maxVal) / 3) {
			// 多线程
			IniteSequenceConfigService.executor.submit(new Runnable() {
				@Override
				public void run() {
					getSequenceToMap(systemName, seqName, "", null, "");
				}
			});

		}
		// 生成一个序列号
		Long seqNum = makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));

		if (currentSeqVal >= Integer.valueOf(maxVal)) {
			crelist.remove(crelist.get(0));
			if (crelist.size() <= 0) {
				getSequenceToMap(systemName, seqName, "", null, "");
			}
		} else {
			crelist.get(0).setCurrentSeqVal(currentSeqVal + 1);
		}
		return seqNum;
	}

	// ==============================================离线===========================================
	/**
	 * 存本地文件
	 * 
	 * @param systemName
	 *            项目名称
	 * @param seqName
	 *            序列名称
	 */
	public Long getStoreLocalSequence(String systemName, String seqName) {
		Long seqNum = null;
		String maxNum = "";
		String maxVal = "";
		String currentNum = "";
		String dateTime = "";
		String proFix = "";// 前缀
		Long disrupt = 0L;
		String mapKey = seqName;
		List<CreateSequence> crelist = null;
		Properties proSequence = null;
		try {
			if (locklists.size() <= 0) {
				throw new SequenceException("未初始化zk");
			}
			synchronized (locklists.get(Math.abs(seqName.hashCode()) % locklists.size())) {
				String filePath = IniteSequenceConfigService.seqFilePath + mapKey + ".properties";
				File file = new File(filePath);
				if (!file.exists()) {
					try {
						file.createNewFile();
						logger.info("存储序列的配置文件创建成功!");
					} catch (IOException e) {
						throw new SequenceException("存储序列的配置文件创建失败！" + e.getMessage());
					}
				}
				proSequence = PropertiesUtil.loadProps(filePath);
				if (null == sequenceObjMap.get(mapKey)) {
					// 读取配置文件，如果有就新建对象将对象存入map中。
					Set<Object> keyValue = proSequence.keySet();
					if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
						getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
					}
					String mapKeyValue = proSequence.getProperty(mapKey);
					if (null != mapKeyValue && !mapKeyValue.equals("")) {
						JSONObject jsonobject = JSONObject.fromObject(mapKeyValue);
						CreateSequence createSequence = (CreateSequence) JSONObject.toBean(jsonobject,
								CreateSequence.class);
						String proMaxVal = createSequence.getSeqVal();
						// 配置文件中的时间
						String times = createSequence.getSquenceTime();
						// 配置文件中的currentnum
						Long proCurrentNum = createSequence.getCurrentNum() + 1;
						Long disRupt = createSequence.getDisrupt();
						// 查询表中的数据
						List<CreateSequence> sequenceFromService = getSequenceModel(seqName);
						if (sequenceFromService.size() > 0) {
							Long currentNum2 = sequenceFromService.get(0).getCurrentNum();
							Long disRupt2 = sequenceFromService.get(0).getDisrupt();
							if (disRupt.intValue() != disRupt2.intValue()) {
								getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
							} else if (!times.equals(sequenceFromService.get(0).getSquenceTime())) {
								getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
							} else if (proCurrentNum > currentNum2) {
								getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
								// 如果配置文件中的val比当前val小,清除对应的数据,重新去获取
							} else if (Long.valueOf(proMaxVal) <= createSequence.getProCurrentVal()) {
								getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
							} else {
								List<CreateSequence> seqlist = new ArrayList<CreateSequence>();
								createSequence.setCurrentSeqVal(createSequence.getProCurrentVal() + 1);
								seqlist.add(createSequence);
								createSequence.setProCurrentVal(createSequence.getCurrentSeqVal() + 99);
								PropertiesUtil.updateProperty(proSequence, mapKey,
										JSONObject.fromObject(createSequence).toString(), filePath);
								sequenceObjMap.put(mapKey, seqlist);
							}
						}
					} else {
						// 如果没有就去服务器重新获取,插入和更新配置文件
						getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
					}
				}
				crelist = sequenceObjMap.get(mapKey);
				if (crelist.size() <= 0) {
					throw new SequenceException("调用服务端序列失败");
				}
				if (crelist.size() > 0 && null != crelist.get(0)) {
					maxNum = crelist.get(0).getSeqNum();
					maxVal = crelist.get(0).getSeqVal();
					currentNum = crelist.get(0).getCurrentNum().toString();// 当前num
					proFix = crelist.get(0).getSeqPrefix();
					dateTime = crelist.get(0).getSquenceTime();
					Integer currentSeqVal = crelist.get(0).getCurrentSeqVal();
					disrupt = crelist.get(0).getDisrupt();

					if (disrupt == 1L) {
						// 获取打乱的序列
						seqNum = disruptOffLineSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal,
								systemName, seqName, crelist, filePath, mapKey, proSequence);
					} else {
						seqNum = normalOffLineSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal,
								systemName, seqName, crelist, filePath, mapKey, proSequence);
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("获取序列失败,序列号的名称为：" + seqName + " ===" + e.getMessage());
		} finally {
			proSequence.clear();
		}
		return seqNum;

	}

	/**
	 * 离线打乱序列
	 * 
	 * @author changhong.deng
	 * @date 2018年6月19日
	 */
	@SuppressWarnings("unchecked")
	private Long disruptOffLineSeqNum(String maxNum, String maxVal, String currentNum, String dateTime, String proFix,
			Integer currentSeqVal, String systemName, String seqName, List<CreateSequence> crelist, String filePath,
			String mapKey, Properties proSequence) {
		Long seqNum = null;

		if (currentSeqVal == null) {
			currentSeqVal = 0;
		}

		String disruptValue = proSequence.getProperty(mapKey + "_disrupt");
		List<Integer> offLineSeqValueList = null;
		if (null != disruptValue && !disruptValue.equals("")) {
			offLineSeqValueList = mapper.fromJson(disruptValue, List.class);
		} else {
			// 如果配置文件丢失，重新获取
			sequenceObjMap.remove(mapKey);
			seqNum = makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));
			getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			return seqNum;
		}

		// 当此时的currnum不等于正在使用序列的currnum时,
		String mapKeyValue = proSequence.getProperty(mapKey);
		if (null != mapKeyValue && !mapKeyValue.equals("")) {
			JSONObject jsonobject = JSONObject.fromObject(mapKeyValue);
			CreateSequence createSequence = (CreateSequence) JSONObject.toBean(jsonobject, CreateSequence.class);
			if (Long.valueOf(currentNum).longValue() != createSequence.getCurrentNum().longValue()) {
				sequenceObjMap.remove(mapKey);
				seqNum = makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));
				return seqNum;
			}

		} else {
			// 如果配置文件丢失，重新获取
			sequenceObjMap.remove(mapKey);
			seqNum = makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));
			getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			return seqNum;
		}

		// 当currentSeqVal是100的整数倍时，读取配置文件,判断是否有对应的配置文件。
		// 如果有判断其中的currentval是不是当前的currentval+100，
		// 如果是，更新配置文件currentval的值+100,当前currentval+5
		if (currentSeqVal % 100 == 0) {
			if (null != mapKeyValue && !mapKeyValue.equals("")) {
				JSONObject jsonobject = JSONObject.fromObject(mapKeyValue);
				CreateSequence createSequence = (CreateSequence) JSONObject.toBean(jsonobject, CreateSequence.class);
				createSequence.setProCurrentVal(createSequence.getProCurrentVal() + 100);
				createSequence.setCurrentSeqVal(createSequence.getCurrentSeqVal() + 100);
				PropertiesUtil.updateProperty(proSequence, mapKey, JSONObject.fromObject(createSequence).toString(),
						filePath);
				currentSeqVal = createSequence.getCurrentSeqVal() + 4;

			} else {
				// 如果配置文件丢失，重新获取
				sequenceObjMap.remove(mapKey);
				// 组装打乱的序列
				seqNum = installSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal,
						offLineSeqValueList);
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
				return seqNum;
			}
		}
		// 当序列号获取到三分之二时，再去服务器获取下一个新的序列
		if (currentSeqVal == (Integer.valueOf(maxVal) / 3 * 2)) {
			Set<Object> keyValue = proSequence.keySet();
			if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			}
			String cacheSequenceValue = proSequence.getProperty(mapKey + "_cache");
			if (null == cacheSequenceValue || cacheSequenceValue.equals("")) {
				getSequenceToMap(systemName, seqName, "middle", proSequence, filePath);
			}
		}
		// 生成一个序列号
		// 组装打乱的序列
		seqNum = installSeqNum(maxNum, maxVal, currentNum, dateTime, proFix, currentSeqVal, offLineSeqValueList);

		if (currentSeqVal >= Integer.valueOf(maxVal) - 2) {
			sequenceObjMap.remove(mapKey);
			Set<Object> keyValue = proSequence.keySet();
			if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			}
			String cacheSequenceValue = proSequence.getProperty(mapKey + "_cache");
			// 如果为空，就重新获取
			if (null == cacheSequenceValue || cacheSequenceValue.equals("")) {
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			} else {
				JSONObject cacheJsonobject = JSONObject.fromObject(cacheSequenceValue);
				CreateSequence cacheSequenceModel = (CreateSequence) JSONObject.toBean(cacheJsonobject,
						CreateSequence.class);
				Long proCurrentNum = Long.valueOf(cacheSequenceModel.getSeqNum());
				String proSequenceTime = cacheSequenceModel.getSquenceTime();
				// 如果num比当前num小，或者时间不一样，重新去取
				if (proCurrentNum <= Long.valueOf(currentNum) || !proSequenceTime.equals(dateTime)) {
					getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
				} else {
					// 将缓存的更新到正在使用的序列中
					PropertiesUtil.updateProperty(proSequence, mapKey,
							JSONObject.fromObject(cacheSequenceModel).toString(), filePath);
					// 清除缓存
					PropertiesUtil.updateProperty(proSequence, mapKey + "_cache", "", filePath);
					// 再次打乱序列
					List<Integer> seqValueList = SeqStringUtils
							.createSolution(Integer.valueOf(cacheSequenceModel.getSeqVal()));
					PropertiesUtil.updateProperty(proSequence, mapKey + "_disrupt", mapper.toJson(seqValueList),
							filePath);
				}
			}

		} else {
			crelist.get(0).setCurrentSeqVal(currentSeqVal + 1);
		}

		return seqNum;
	}

	private Long normalOffLineSeqNum(String maxNum, String maxVal, String currentNum, String dateTime, String proFix,
			Integer currentSeqVal, String systemName, String seqName, List<CreateSequence> crelist, String filePath,
			String mapKey, Properties proSequence) {

		Long seqNum = null;
		if (currentSeqVal == null) {
			currentSeqVal = 1;
		}

		// 当currentSeqVal是100的整数倍时，读取配置文件,判断是否有对应的配置文件。
		// 如果有判断其中的currentval是不是当前的currentval+100，
		// 如果是，更新配置文件currentval的值+100,当前currentval+5
		if (currentSeqVal % 100 == 0) {
			Set<Object> keyValue = proSequence.keySet();
			if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			}
			String mapKeyValue = proSequence.getProperty(mapKey);
			if (null != mapKeyValue && !mapKeyValue.equals("")) {
				JSONObject jsonobject = JSONObject.fromObject(mapKeyValue);
				CreateSequence createSequence = (CreateSequence) JSONObject.toBean(jsonobject, CreateSequence.class);
				if (Long.valueOf(currentNum).longValue() != createSequence.getCurrentNum().longValue()) {
					sequenceObjMap.remove(mapKey);
					return makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));
				}

				createSequence.setProCurrentVal(createSequence.getProCurrentVal() + 100);
				createSequence.setCurrentSeqVal(createSequence.getCurrentSeqVal() + 100);
				PropertiesUtil.updateProperty(proSequence, mapKey, JSONObject.fromObject(createSequence).toString(),
						filePath);
				currentSeqVal = createSequence.getCurrentSeqVal() + 4;

			} else {
				// 如果配置文件丢失，重新获取
				sequenceObjMap.remove(mapKey);
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
				return makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));
			}
		}
		// 当序列号获取到一半时，再去服务器获取下一个新的序列
		if (currentSeqVal == (Integer.valueOf(maxVal) / 3 * 2)) {
			Set<Object> keyValue = proSequence.keySet();
			if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			}
			String cacheSequenceValue = proSequence.getProperty(mapKey + "_cache");
			if (null == cacheSequenceValue || cacheSequenceValue.equals("")) {
				getSequenceToMap(systemName, seqName, "middle", proSequence, filePath);
			}
		}
		// 生成一个序列号
		seqNum = makeSeqFunction(dateTime, maxVal, maxNum, proFix, currentNum, String.valueOf(currentSeqVal));

		if (currentSeqVal >= Integer.valueOf(maxVal) - 1) {
			sequenceObjMap.remove(mapKey);
			Set<Object> keyValue = proSequence.keySet();
			if (keyValue.size() > 3) {// 特殊异常，有可能路径错误
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			}
			String cacheSequenceValue = proSequence.getProperty(mapKey + "_cache");
			// 如果为空，就重新获取
			if (null == cacheSequenceValue || cacheSequenceValue.equals("")) {
				getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
			} else {
				JSONObject cacheJsonobject = JSONObject.fromObject(cacheSequenceValue);
				CreateSequence cacheSequenceModel = (CreateSequence) JSONObject.toBean(cacheJsonobject,
						CreateSequence.class);
				Long proCurrentNum = Long.valueOf(cacheSequenceModel.getSeqNum());
				String proSequenceTime = cacheSequenceModel.getSquenceTime();
				// 如果num比当前num小，或者时间不一样，重新去取
				if (proCurrentNum <= Long.valueOf(currentNum) || !proSequenceTime.equals(dateTime)) {
					getSequenceToMap(systemName, seqName, "first", proSequence, filePath);
				} else {
					// 将缓存的更新到正在使用的序列中
					PropertiesUtil.updateProperty(proSequence, mapKey,
							JSONObject.fromObject(cacheSequenceModel).toString(), filePath);
					// 清除缓存
					PropertiesUtil.updateProperty(proSequence, mapKey + "_cache", "", filePath);
				}
			}
		} else {
			crelist.get(0).setCurrentSeqVal(currentSeqVal + 1);
		}

		return seqNum;
	}

	/**
	 * 客户端调用服务端，获取序列，存入到map中
	 * 
	 * @param systemName
	 *            项目名称
	 * @param seqName
	 *            序列名称
	 */
	public void getSequenceToMap(String systemName, String seqName, String fromWhere, Properties proSequence,
			String filePath) {
		CreateSequence createSequence = null;
		String mapKey = "";

		try {
			createSequence = getSequenceFromClient(systemName, seqName);
			if (createSequence.getSeqName() == null || createSequence == null) {
				throw new Exception("数据库中没有配置序列" + seqName);
			}
			mapKey = seqName;
			List<CreateSequence> seqlist = sequenceObjMap.get(mapKey);
			if (seqlist == null) {
				seqlist = new ArrayList<CreateSequence>();
			}

			seqlist.add(createSequence);
			sequenceObjMap.put(mapKey, seqlist);
			if (fromWhere.equals("first")) {
				// 第一次插入或更新 using_sequence.properties配置文件
				// 初始写入时currentval+100。
				if (null == createSequence.getCurrentSeqVal()) {
					createSequence.setProCurrentVal(100);
				} else {
					createSequence.setProCurrentVal(createSequence.getCurrentSeqVal() + 100);
				}
				// 清除这个文件
				PropertiesUtil.updateAllPropertiesNull(proSequence, filePath);
				PropertiesUtil.updateProperty(proSequence, mapKey, JSONObject.fromObject(createSequence).toString(),
						filePath);
				// 将缓存的清空
				// PropertiesUtil.updateProperty(useingSequence, mapKey +
				// "_cache", "", filePath);
				Long disrupt = createSequence.getDisrupt();
				if (disrupt == 1L) {
					// 更新打乱的list
					List<Integer> offLineSeqValueList = SeqStringUtils
							.createSolution(Integer.valueOf(createSequence.getSeqVal()));
					PropertiesUtil.updateProperty(proSequence, mapKey + "_disrupt", mapper.toJson(offLineSeqValueList),
							filePath);
				}

			} else if (fromWhere.equals("middle")) {
				// 更新预留的对象
				if (null == createSequence.getCurrentSeqVal()) {
					createSequence.setProCurrentVal(100);
				} else {
					createSequence.setProCurrentVal(createSequence.getCurrentSeqVal() + 100);
				}
				PropertiesUtil.updateProperty(proSequence, mapKey + "_cache",
						JSONObject.fromObject(createSequence).toString(), filePath);
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException(e.getMessage());
		}

	}

	/**
	 * 序列拼接
	 * 
	 * @param dateTime
	 * @param maxVal
	 * @param maxNum
	 * @param proFix
	 * @param currentNum
	 * @param parm
	 * @return
	 */
	private Long makeSeqFunction(String dateTime, String maxVal, String maxNum, String proFix, String currentNum,
			String parm) {
		dateTime = dateTime.replaceAll("-", "");
		dateTime = dateTime.substring(2, dateTime.length());
		String currentSeqNum = SeqStringUtils.getSquByNum(maxNum, currentNum);
		String currentSeqValue = SeqStringUtils.getSquByNum(maxVal, parm);
		return Long.valueOf(proFix.trim() + dateTime + currentSeqNum + currentSeqValue);
	}

	public static SequenceActionService getSequenceActionService() {
		return sequenceActionService;
	}

	public static void setSequenceActionService(SequenceActionService sequenceActionService) {
		SequenceCliActionService.sequenceActionService = sequenceActionService;
	}

	// ==================================================================
	/**
	 * 获取自动递增序列
	 * 
	 * @param seqName
	 * @return
	 * @author changhong.deng
	 * @date 2018年3月12日上午9:55:56
	 * @return Long
	 */
	public String getAutomicSequence(String seqName, Integer num, Long tenantNumId, Long dataSign) {

		try {

			return sequenceActionService.getAutomicSeq(seqName, num, tenantNumId, dataSign);

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("获取自增长序列失败:" + e.getMessage());
		}

	}

	/**
	 * 返回离线序列信息
	 * 
	 * @author changhong.deng
	 * @date 2018年7月23日
	 */
	public List<Map<String, Object>> getOfflineSeqInfo(Long subUnitNumId) {
		try {

			return sequenceActionService.getOfflineSeqInfo(subUnitNumId);

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new SequenceException("返回离线序列失败:" + e.getMessage());
		}

	}

}
