package com.gb.soa.sequence.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.gb.soa.sequence.exception.SequenceException;

public class SequenceService {
	protected static Logger logger = LoggerFactory
			.getLogger(SequenceService.class);

	private SequenceCliActionService scli = new SequenceCliActionService();

	/**
	 * 获取序列号（没有业务单号的序列，目前只有消息中心才会用到）
	 * 
	 * @author ljj
	 * @date 2016年10月28日 上午10:23
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @throws Exception
	 */
	public Long getNoSubSequence(String systemName, String SeqName)
			throws SequenceException {
		return scli.getSequence(systemName, SeqName);
	}


	public List<Object> getNoSubSequenceBath(String systemName, String seqName,
			Integer size) {
		List<Object> serieses = new ArrayList<Object>();
		for (int i = 0; i < size; i++) {
			serieses.add(getNoSubSequence(systemName, seqName));
		}
		return serieses;
	}

}
