package com.gb.soa.sequence.service;

import com.gb.soa.sequence.exception.SequenceException;

public class SubIdGetService {

    /**
     * 获取分库号
     * 
     * @author ljj
     * @date 2016年11月3日 下午09:46:06
     * @version <b>1.0.0</b>
     * @param seq 序列号
     * @throws Exception
     */
    public Long getSubIdBySeq(String seq) {
        Long subId = null;
        try {
            subId = Long.valueOf(seq.substring(seq.length() - 3, seq.length()));
        } catch (Exception ex) {
            throw new SequenceException("传入的序列号至少三位且最后三位必须是数字");
        }
        return subId;
    }
}
