package com.gb.soa.sequence.service;

import java.util.ArrayList;
import java.util.List;

import com.gb.soa.sequence.exception.SequenceException;
import com.gb.soa.sequence.util.SeqStringUtils;

public class SubSequenceService {

	private SequenceService seq = new SequenceService();

	/**
	 * 获取序列号
	 * 
	 * @author ljj
	 * @date 2016年10月25日 下午14:25:06
	 * @version <b>1.0.0</b>
	 * @param systemName   系统名
	 * @param SeqName      序列名
	 * @param subId        分库ID，会员编号，或者 租户号
	 * @throws Exception
	 */
	public String getSequence(String systemName, String SeqName,String subId) throws SequenceException {
		if(subId==null){
			throw new 	SequenceException("分库号不能为null");
		}
		if(subId.toString().length()>=3){
			subId=subId.toString().substring(subId.toString().length() - 3,
					subId.toString().length());
		}else{
		    subId=SeqStringUtils.leftPad(subId.toString(),3, '0');
		}
		Long nosubseq=seq.getNoSubSequence(systemName, SeqName);
		String newSeq=makeSeqFunction(nosubseq,subId);
		return newSeq;

	}
	
	
	private String makeSeqFunction(Long nosubseq, String subId) {
		return		nosubseq.toString()+ subId;
	}


	
	/**
	 * 获取序列号
	 * 
	 * @author ljj
	 * @date 2016年10月25日 下午14:25:06
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @param subId
	 *          会员编号
	 * @throws Exception
	 */
	public String getMemberSequence(String systemName, String SeqName,String subId) throws SequenceException {
		if(subId==null){
			throw new 	SequenceException("分库号不能为null");
		}
		if(subId.toString().length()>=3){
			subId=subId.toString().substring(subId.toString().length() - 3,
					subId.toString().length());
		}else{
		    subId=SeqStringUtils.leftPad(subId.toString(),3, '0');
		}
		Long nosubseq=seq.getNoSubSequence(systemName, SeqName);
		String newSeq=makeSeqFunction(nosubseq,subId);
		return newSeq;

	}


	public List<String> getSequenceBatch(String systemName, String seqName,
			String routeId, Integer size) {
		List<String>serieses=new ArrayList<String>();
		for(int i=0;i<size;i++){
			serieses.add(getSequence(systemName,seqName,routeId));
		}
		return serieses;
		
	}
	
	
	
	/**
	 * 获取没有年月日的序列号 
	 * @author ljj
	 * @date 2017年10月30日 上午10:30:30
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 */
	public Long getNoDateSequence(String systemName, String SeqName) throws SequenceException {
		Long nosubseq=seq.getNoSubSequence(systemName, SeqName);
		String newYear=nosubseq.toString().substring(1,2);
		String newMonth=String.valueOf(Integer.valueOf(nosubseq.toString().substring(2,4))+55);
		String newDay=String.valueOf(Integer.valueOf(nosubseq.toString().substring(4,6))+21);
		String newSeq=nosubseq.toString().substring(6,nosubseq.toString().length());
		
		return Long.valueOf(newYear+newMonth+newDay+newSeq);

	}
	
}
