package com.gb.soa.sequence.util;

import com.gb.soa.sequence.service.SequenceActionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;

public class DubboImpl {

    public static Object initDubboForSpringcloud(String registryUrl) {
        return initDubboForSpringcloud(registryUrl, null);
    }

    public static Object initDubboForSpringcloud(String registryUrl, Map<String, String> registryParameters) {
        ReferenceConfig<SequenceActionService> reference = new ReferenceConfig<>();
        reference.setInterface(SequenceActionService.class);
        // 当前应用配置
        ApplicationConfig application = new ApplicationConfig();
        application.setName("sequence-client");
        // 连接注册中心配置
        List<RegistryConfig> config = new ArrayList<>();
        RegistryConfig registry = new RegistryConfig();
        registry.setAddress(registryUrl);
        registry.updateParameters(registryParameters);
        config.add(registry);
        reference.setApplication(application);
        reference.setRegistries(config);
        reference.setCheck(false);
        reference.setRetries(0);
        return reference.get();

    }


}
