package com.gb.soa.sequence.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
	private static Properties properties = null;

	/**
	 * 加载属性文件
	 * 
	 * @param filePath
	 *            文件路径
	 * @return
	 * @throws IOException
	 */
	public synchronized static Properties loadProps(String path) {
		properties = new Properties();
		InputStream in = null;
		try {
			in = new BufferedInputStream(new FileInputStream(path));
			properties.load(in);

		} catch (Exception e) {
			e.printStackTrace();
		} 
		return properties;
	}

	/**
	 * 读取配置文件
	 * 
	 * @param properties
	 *            配置文件
	 * @param key
	 * @return
	 */
	public static String getString(Properties properties, String key) {
		return properties.getProperty(key);
	}

	/*
	 * 更新properties文件的键值对 如果该主键已经存在，更新该主键的值； 如果该主键不存在，则插入一对键值。
	 * 
	 * @param keyname 键名
	 * 
	 * @param keyvalue 键值
	 */
	public static void updateProperty(Properties properties, String keyname, String keyvalue, String path) {
		try {

			// 从输入流中读取属性列表（键和元素对）
			properties.setProperty(keyname, keyvalue);
			FileOutputStream outputFile = new FileOutputStream(path);
			properties.store(outputFile, null);
			outputFile.flush();
			outputFile.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 读取properties的全部信息
	 * 
	 * @throws FileNotFoundException
	 *             配置文件没有找到
	 * @throws IOException
	 *             关闭资源文件，或者加载配置文件错误
	 * 
	 */
	public Map<String, String> readAllProperties() throws FileNotFoundException, IOException {
		// 保存所有的键值
		Map<String, String> map = new HashMap<String, String>();
		Enumeration en = properties.propertyNames();
		while (en.hasMoreElements()) {
			String key = (String) en.nextElement();
			String Property = properties.getProperty(key);
			map.put(key, Property);
		}
		return map;
	}

	// 根据Key移除value
	public static boolean removeValue(Properties properties, String key, String path) {
		try {
			properties.remove(key);
			OutputStream fos = new FileOutputStream(path);
			properties.store(fos, "Delete '" + key + "' value");
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * 更新所有的key的值为null
	 * 
	 * @param properties
	 * @throws FileNotFoundException
	 * @throws IOException
	 * @author changhong.deng
	 * @date 2018年1月11日下午2:36:49
	 * @return void
	 */
	public static void updateAllPropertiesNull(Properties properties, String path)
			throws FileNotFoundException, IOException {
		Enumeration en = properties.propertyNames();
		while (en.hasMoreElements()) {
			String key = (String) en.nextElement();
			updateProperty(properties, key, "", path);
			// String Property = properties.getProperty(key);
		}
	}

	/**
	 * 判断项目是在windos上,还是linux上
	 * 
	 * @return
	 * @author changhong.deng
	 * @date 2018年1月19日上午9:45:39
	 * @return boolean
	 */
	public static boolean isOSLinux() {
		Properties prop = System.getProperties();
		String os = prop.getProperty("os.name");
		if (os != null && os.toLowerCase().indexOf("linux") > -1) {
			return true;
		} else {
			return false;
		}
	}

}
