package com.gb.soa.sequence.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.gb.soa.sequence.exception.SequenceException;
import com.gb.soa.sequence.service.IniteSequenceConfigService;
import com.gb.soa.sequence.service.SequenceCliActionService;
import com.gb.soa.sequence.service.SequenceService;
import com.gb.soa.sequence.service.SubIdGetService;
import com.gb.soa.sequence.service.SubSequenceService;

public class SeqGetUtil {
	private static SubIdGetService sgs = new SubIdGetService();

	private static SubSequenceService sg = new SubSequenceService();

	private static SequenceService ss = new SequenceService();

	private static IniteSequenceConfigService izfs = new IniteSequenceConfigService();
	
	private static SequenceCliActionService sc = new SequenceCliActionService();

	/**
	 * 初始化zk地址
	 * 
	 * @author ljj
	 * @date 2016年10月28日 上午10:23
	 * @version <b>1.0.0</b>
	 * @param zkaddress
	 */
	@Deprecated
	public static void initeZkConfig(String zkaddress) {
		izfs.initSequenceConfig();
	}

	public static void initeSequenceConfig(NacosConfigManager nacosConfigManager) {
		izfs.initSequenceConfig(nacosConfigManager);
	}

	/**
	 * 获取序列号（没有业务单号的序列，目前只有消息中心才会用到）
	 * 
	 * @author ljj
	 * @date 2016年10月28日 上午10:23
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @throws Exception
	 */
	public static Long getNoSubSequence(String systemName, String SeqName) {
		return ss.getNoSubSequence(systemName, SeqName);
	}

	/**
	 * 批量获取序列号（没有业务单号的序列，目前只有消息中心才会用到）
	 * 
	 * @author ljj
	 * @date 2016年10月28日 上午10:23
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @param size
	 * 批量获取序列的数量
	 */
	public static List<Object> getNoSubSequenceBath(String systemName, String SeqName, Integer size) {
		return ss.getNoSubSequenceBath(systemName, SeqName, size);
	}

	/**
	 * 获取序列号
	 * 
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @param routeId
	 *            分库单号id，序号生成时取该id的分库信息
	 * @return
	 */
	public static String getSequence(String systemName, String SeqName, String routeId) {
		return sg.getSequence(systemName, SeqName, routeId);
	}

	/**
	 * 获取序列号
	 * 
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @param routeId
	 *            分库单号id，序号生成时取该id的分库信息
	 * @return
	 */
	public static List<String> getSequenceBatch(String systemName, String SeqName, String routeId, Integer size) {
		return sg.getSequenceBatch(systemName, SeqName, routeId, size);
	}

	/**
	 * 获取会员编号
	 * 
	 * @param systemName
	 * @return
	 */
	public static String getMemberSequence(String systemName) {
		return String.valueOf(ss.getNoSubSequence(systemName, "ex_arc_consumer_user_usernumid"));
	}

	/**
	 * 获取分库号
	 * 
	 * @author ljj
	 * @date 2016年11月3日 下午09:46:06
	 * @version <b>1.0.0</b>
	 * @param  seq
	 *            序列号
	 * @throws Exception
	 */
	public static Long getSubIdBySeq(String seq) {
		return sgs.getSubIdBySeq(seq);
	}


	/**
	 * 获取第三方编号
	 * 
	 * @param systemName
	 * @param seqName
	 * @param date
	 *            yyyy-MM-dd HH:mm:ss
	 * @return
	 */
	public static Long getThirdOrderHdrSequenceByDate(String systemName, String seqName, String date) {
		String oldSeq = String.valueOf(ss.getNoSubSequence(systemName, seqName));
		String newDate = buildDate(date);
		String newSeq = newDate + oldSeq.substring(5, oldSeq.length());
		return Long.valueOf(newSeq);
	}

	/**
	 * 获取小票号
	 * 
	 * @param systemName
	 *            系统名
	 * @param SeqName
	 *            序列名
	 * @param routeId
	 *            分库单号id，序号生成时取该id的分库信息
	 * @param date
	 *            时间 yyyy-mm-ss
	 * @return
	 */
	public static String getTmlNumByDate(String systemName, String SeqName, String routeId, String date) {
		String sequence = sg.getSequence(systemName, SeqName, routeId);
		String newDate = buildDate(date);
		String newSeq = sequence.substring(0, 2) + newDate + sequence.substring(5, sequence.length());
		return newSeq;
	}

	private static String buildDate(String date) {
		Date dt = null;
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			dt = sdf.parse(date);
		} catch (ParseException e) {
			throw new SequenceException("获取序列号时时间格式转换异常" + date);
		}
		Calendar cld = Calendar.getInstance();
		cld.setTime(dt);
		String year = String.valueOf(cld.get(Calendar.YEAR)).substring(2, 4);
		String month = String.valueOf(cld.get(Calendar.MONTH) + 1);
		if (month.length() == 1) {
			month = "0" + month;
		}
		String day = String.valueOf(cld.get(Calendar.DATE));
		if (day.length() == 1) {
			day = "0" + day;
		}

		return year + month + day;
	}

	/**
	 * 获取分库号（最后三位）
	 * 
	 * @author ljj
	 * @date 2017年8月11日 下午14:27
	 * @version <b>1.0.0</b>
	 * @param routerId
	 *            入参数
	 * @throws Exception
	 */
	public static Integer getSharedId(String routerId) {
		if (routerId.length() >= 3) {
			return Integer.valueOf(routerId.substring(routerId.length() - 3, routerId.length()));
		} else {
			return Integer.valueOf(routerId);
		}
	}

	/**
	 * 获取分库号（最后三位）
	 * 
	 * @author ljj
	 * @date 2017年8月11日 下午14:27
	 * @version <b>1.0.0</b>
	 * @param routerId
	 *            入参数
	 * @throws Exception
	 */
	public static Integer getSharedId(Long routerId) {
		if (routerId.toString().length() >= 3) {
			return Integer.valueOf(
					routerId.toString().substring(routerId.toString().length() - 3, routerId.toString().length()));
		} else {
			return Integer.valueOf(routerId.toString());
		}
	}

	/**
	 * 获取没有分库的序列号
	 * 
	 * @author ljj
	 * @date 2017年10月30日 下午10:51
	 * @version <b>1.0.0</b>
	 * @param systemName
	 *            入参数
	 * @throws Exception
	 */
	public static Long getNoDateSequence(String systemName, String SeqName) {
		return sg.getNoDateSequence(systemName, SeqName);
	}
	
	//===========================参数中没有项目名称=====================
	/**
	 * 批量获取序列号（没有业务单号的序列，目前只有消息中心才会用到）
	 * 
	 * @author ljj
	 * @date 2016年10月28日 上午10:23
	 * @version <b>1.0.0</b>
	 * @param SeqName 序列名
	 * @param size  数量
	 */
	public static List<Object> getNoSubSequenceBath(String SeqName, Integer size) {
		String systemName = "";
		return ss.getNoSubSequenceBath(systemName, SeqName, size);
	}

	/**
	 * 获取序列号
	 * 
	 * @param SeqName
	 *            序列名
	 * @param routeId
	 *            分库单号id，序号生成时取该id的分库信息
	 * @return
	 */
	public static String getSequence(String SeqName, String routeId) {
		String systemName = "";
		return sg.getSequence(systemName, SeqName, routeId);
	}

	/**
	 * 获取序列号
	 * 
	 * @param SeqName  序列名
	 * @param routeId  分库单号id，序号生成时取该id的分库信息
	 * @param size     数量

	 * @return
	 */
	public static List<String> getSequenceBatch(String SeqName, String routeId, Integer size) {
		String systemName = "";
		return sg.getSequenceBatch(systemName, SeqName, routeId, size);
	}

	/**
	 * 获取会员编号
	 * 
	 * @return
	 */
	public static String getMemberSequence() {
		String systemName = "";
		return String.valueOf(ss.getNoSubSequence(systemName, "ex_arc_consumer_user_usernumid"));
	}

	

	/**
	 * 获取第三方编号
	 * 
	 * @param seqName
	 * @param date
	 *            yyyy-MM-dd HH:mm:ss
	 * @return
	 */
	public static Long getThirdOrderHdrSequenceByDate(String seqName, String date) {
		String systemName = "";
		String oldSeq = String.valueOf(ss.getNoSubSequence(systemName, seqName));
		String newDate = buildDate(date);
		String newSeq = newDate + oldSeq.substring(5, oldSeq.length());
		return Long.valueOf(newSeq);
	}

	/**
	 * 获取小票号
	 * 
	 * @param SeqName
	 *            序列名
	 * @param routeId
	 *            分库单号id，序号生成时取该id的分库信息
	 * @param date
	 *            时间 yyyy-mm-ss
	 * @return
	 */
	public static String getTmlNumByDate(String SeqName, String routeId, String date) {
		String systemName = "";
		String sequence = sg.getSequence(systemName, SeqName, routeId);
		String newDate = buildDate(date);
		String newSeq = sequence.substring(0, 2) + newDate + sequence.substring(5, sequence.length());
		return newSeq;
	}
	/**
	 * 获取没有年月日的序列号 
	* @author changhong.deng  
	* @date 2018年6月15日
	 */
	public static Long getNoDateSequence(String SeqName) {
		String systemName = "";
		return sg.getNoDateSequence(systemName, SeqName);
	}
	
	//================通用===================================
	
	/*
	 * 通用序列号
	 */
	public static Long getNoSubSequence(String SeqName) {
		String systemName = "";
		return sc.getSequence(systemName, SeqName);
	}
	
	/**
	 * 自增长序列
	 * @param SeqName
	 * @return 
	 * @author changhong.deng
	 * @date 2018年3月12日下午12:46:38
	 * @return Long
	 */
	public static String getAutomicSequence(String SeqName,Integer num,Long tenantNumId,Long dataSign) {
		return sc.getAutomicSequence(SeqName,num,tenantNumId,dataSign);
	}
	
	/**
	 * 自增序列,缓存值没有意义,取表里面的缓存值
	* @author changhong.deng  
	* @date 2018年6月21日
	 */
	public static String getAutomicSequence(String SeqName,Long tenantNumId,Long dataSign) {
		return sc.getAutomicSequence(SeqName,1,tenantNumId,dataSign);
	}
	
	/**
	 * 没有租户和测试标识之分，共用一个
	* @author changhong.deng  
	* @date 2018年10月9日
	 */
	public static String getAutomicSequenceNoTenAndData(String SeqName) {
		return sc.getAutomicSequence(SeqName,1,0L,0L);
	}
	/**
	 * 返回离线序列
	* @author changhong.deng  
	* @date 2018年7月23日
	 */
	public static List<Map<String, Object>> getOfflineSeqInfo(Long subUnitNumId) {
		return sc.getOfflineSeqInfo(subUnitNumId);
	}
	
	
	
}
