/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.data.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.xinqiyi.framework.data.annotation.BaseDataRedisAnnotation;
import com.xinqiyi.framework.data.dao.repository.DataRedisRepository;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BaseDataOperateAspect {
    private static final Logger log = LoggerFactory.getLogger(BaseDataOperateAspect.class);
    @Autowired
    private DataRedisRepository dataRedisRepository;

    @Pointcut(value="execution(* com.xinqiyi..*.adapter..*(..)) ")
    public void bizPointCut() {
    }

    @Around(value="bizPointCut()")
    public Object apiCall(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (!this.dataRedisRepository.dataRedisProperties.isEnabled()) {
            return joinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method callMethod = methodSignature.getMethod();
        BaseDataRedisAnnotation baseDataRedisAnnotation = callMethod.getAnnotation(BaseDataRedisAnnotation.class);
        if (baseDataRedisAnnotation != null) {
            Object obj = null;
            Object dataId = this.getDataId(args);
            if (dataId instanceof String) {
                String keyPrefix = baseDataRedisAnnotation.dataKeyPrefix() + dataId;
                if (StringUtils.isBlank((CharSequence)keyPrefix)) {
                    return joinPoint.proceed();
                }
                boolean isUpdateCache = baseDataRedisAnnotation.isUpdateCache();
                if (isUpdateCache) {
                    this.dataRedisRepository.deleteBaseData(keyPrefix);
                    return joinPoint.proceed();
                }
                String resultObj = this.dataRedisRepository.selectBaseData(keyPrefix);
                if (resultObj != null) {
                    try {
                        Class<?> methodReturnType = callMethod.getReturnType();
                        return JSON.parseObject((String)resultObj, methodReturnType);
                    }
                    catch (Exception e) {
                        log.error("BaseDataOperateMapperAspect.apiCall.ERROR", (Throwable)e);
                    }
                }
                if ((obj = joinPoint.proceed()) != null && !obj.toString().equals("null")) {
                    this.dataRedisRepository.saveBaseDataRedis(obj, keyPrefix);
                }
                return obj;
            }
            if (dataId instanceof List) {
                List dataIdList = (List)dataId;
                String objectFullClassName = baseDataRedisAnnotation.objectFullClassName();
                Class<?> objClz = Class.forName(objectFullClassName);
                ArrayList newParamList = new ArrayList();
                JSONArray newResultList = new JSONArray();
                dataIdList.stream().forEach(id -> {
                    String keyPrefix = baseDataRedisAnnotation.dataKeyPrefix() + id;
                    String resultObj = this.dataRedisRepository.selectBaseData(keyPrefix);
                    if (StringUtils.isBlank((CharSequence)resultObj)) {
                        newParamList.add(id);
                    } else {
                        Object objs = JSON.parseObject((String)resultObj, (Class)objClz);
                        newResultList.add(objs);
                    }
                });
                if (CollUtil.isNotEmpty(newParamList)) {
                    ReflectUtil.setFieldValue((Object)joinPoint, (String)"args", newParamList);
                    obj = joinPoint.proceed();
                    if (obj != null && !obj.toString().equals("null")) {
                        List resultList = (List)obj;
                        resultList.stream().forEach(result -> {
                            String resultId = ReflectUtil.getFieldValue((Object)result, (String)"id").toString();
                            String keyPrefix = baseDataRedisAnnotation.dataKeyPrefix() + resultId;
                            this.dataRedisRepository.saveBaseDataRedis(result, keyPrefix);
                        });
                        newResultList.addAll((Collection)resultList);
                    }
                }
                obj = newResultList;
            }
            return obj;
        }
        return joinPoint.proceed();
    }

    private Object getDataId(Object[] args) {
        if (args[0] instanceof Long) {
            return ((Long)args[0]).toString();
        }
        if (args[0] instanceof Integer) {
            return ((Integer)args[0]).toString();
        }
        if (args[0] instanceof String) {
            return args[0].toString();
        }
        if (args[0] instanceof List) {
            return args[0];
        }
        return null;
    }
}

