/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.data.dao.repository;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.data.config.DataRedisProperties;
import com.xinqiyi.framework.data.dao.repository.DataRedisKeyBuilder;
import com.xinqiyi.framework.redis.RedisHelper;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRedisRepository {
    private static final Logger log = LoggerFactory.getLogger(DataRedisRepository.class);
    @Autowired
    public DataRedisProperties dataRedisProperties;

    public boolean saveBaseDataRedis(Object resultObj, String keyPrefix) {
        long randomTime = RandomUtil.randomLong((long)600L);
        String baseDataRedisKey = DataRedisKeyBuilder.buildDataRedisTableKey(keyPrefix);
        String jsonValue = JSON.toJSONString((Object)resultObj);
        RedisHelper.getRedisTemplate().opsForValue().set((Object)baseDataRedisKey, (Object)jsonValue, this.dataRedisProperties.getExpireTime() + randomTime, TimeUnit.SECONDS);
        return true;
    }

    public String selectBaseData(String keyPrefix) {
        String baseDataRedisKey = DataRedisKeyBuilder.buildDataRedisTableKey(keyPrefix);
        boolean hasRedisKey = RedisHelper.getRedisTemplate().hasKey((Object)baseDataRedisKey);
        if (!hasRedisKey) {
            return null;
        }
        String redisValue = (String)RedisHelper.getRedisTemplate().opsForValue().get((Object)baseDataRedisKey);
        if (StringUtils.isEmpty((CharSequence)redisValue)) {
            return null;
        }
        return redisValue;
    }

    public void deleteBaseData(String keyPrefix) {
        try {
            String redisKey = DataRedisKeyBuilder.buildDataRedisTableKey(keyPrefix);
            RedisHelper.getRedisTemplate().delete((Object)redisKey);
        }
        catch (Exception e) {
            log.error("DataRedisRepository.deleteBaseData.ERROR", (Throwable)e);
        }
    }
}

