/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.auth.LoginUserInfoHelper;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.excel.ExcelExportConfig;
import com.xinqiyi.framework.excel.ExcelFileType;
import com.xinqiyi.framework.excel.ExportExcelResult;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.framework.excel.model.TaskInfo;
import com.xinqiyi.framework.excel.progress.ProgressHandler;
import com.xinqiyi.framework.excel.util.ExcelRedisHelper;
import com.xinqiyi.framework.file.StorageFileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.ResourceUtils;

public abstract class AbstractExcelExportEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelExportEngine.class);
    private static final int MAX_EXPORT_ROW_NUM = 1000000;
    private static final int MAX_PER_PAGE_ROW_NUM = 500;
    private static final String DEFAULT_EXCEL_FONT_NAME = "simsun";
    private static final short DEFAULT_EXCEL_FONT_SIZE = 10;
    public static final String EXCEL_HEAD_DATA_TYPE_NUMBER = "NUMBER";
    public static final String EXCEL_HEAD_DATA_TYPE_INTEGER = "INTEGER";
    public static final String EXCEL_HEAD_DATA_TYPE_STRING = "STRING";

    public abstract int getTotalRowCount(JSONObject var1);

    public abstract List<Map<String, Object>> getContentDatas(JSONObject var1);

    public abstract List<ExcelHeadData> getExcelHeadData(JSONObject var1);

    protected List<Map<String, Object>> getColumnSummary(JSONObject paramObj) {
        return new ArrayList<Map<String, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="dynamicAsyncExcelPoolTaskExecutor")
    public Future<ExportExcelResult> asyncStartExport(JSONObject paramObj, ExcelExportConfig excelExportConfig, List<ExcelHeadData> exportHeaders, StorageFileHelper storageFileHelper) {
        ExportExcelResult exportExcelResult = null;
        try {
            LoginUserInfo loginUserInfo;
            if (paramObj.containsKey((Object)"loginUserInfo")) {
                loginUserInfo = (LoginUserInfo)paramObj.getObject("loginUserInfo", LoginUserInfo.class);
                LoginUserInfoHelper.setLoginUserInfoThreadLocal((LoginUserInfo)loginUserInfo);
            }
            exportExcelResult = this.startExport(paramObj, excelExportConfig, exportHeaders, storageFileHelper);
            loginUserInfo = new AsyncResult((Object)exportExcelResult);
            return loginUserInfo;
        }
        catch (Exception e) {
            log.error("AbstractExcelTemplateExportEngine.asyncStartTemplateExport.ERROR", (Throwable)e);
        }
        finally {
            exportExcelResult = new ExportExcelResult(false, "\u5f02\u6b65\u666e\u901a\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef");
            LoginUserInfoHelper.removeLoginUserInfoThreadLocal();
        }
        return new AsyncResult((Object)exportExcelResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="dynamicAsyncExcelPoolTaskExecutor")
    public Future<ExportExcelResult> asyncStartEasyExport(JSONObject paramObj, ExcelExportConfig excelExportConfig, List<ExcelHeadData> exportHeaders, StorageFileHelper storageFileHelper, ProgressHandler progressHandler) {
        ExportExcelResult exportExcelResult = null;
        try {
            LoginUserInfo loginUserInfo;
            if (paramObj.containsKey((Object)"loginUserInfo")) {
                loginUserInfo = (LoginUserInfo)paramObj.getObject("loginUserInfo", LoginUserInfo.class);
                LoginUserInfoHelper.setLoginUserInfoThreadLocal((LoginUserInfo)loginUserInfo);
                log.info("AbstractExcelExportEngine.asyncStartEasyExport={}", (Object)JSON.toJSONString((Object)loginUserInfo));
            } else {
                log.info("AbstractExcelExportEngine.asyncStartEasyExport.noLoginUserInfo");
            }
            exportExcelResult = this.startExportEasy(paramObj, excelExportConfig, exportHeaders, storageFileHelper, progressHandler);
            loginUserInfo = new AsyncResult((Object)exportExcelResult);
            return loginUserInfo;
        }
        catch (Exception e) {
            log.error("AbstractExcelTemplateExportEngine.asyncStartEasyExport.ERROR", (Throwable)e);
        }
        finally {
            exportExcelResult = new ExportExcelResult(false, "\u5f02\u6b65\u666e\u901a\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef");
            LoginUserInfoHelper.removeLoginUserInfoThreadLocal();
        }
        return new AsyncResult((Object)exportExcelResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportExcelResult startExport(JSONObject paramObj, ExcelExportConfig excelExportConfig, List<ExcelHeadData> exportHeaders, StorageFileHelper storageFileHelper) {
        Object wb = null;
        try {
            if (CollUtil.isEmpty(exportHeaders)) {
                exportHeaders = this.getExcelHeadData(paramObj);
            }
            wb = excelExportConfig.getExcelFileType() == ExcelFileType.EXCEL2007 ? new XSSFWorkbook() : new HSSFWorkbook();
            Sheet sheet = wb.createSheet(excelExportConfig.getExportSheetName());
            if (log.isDebugEnabled()) {
                log.debug("###ExportExcelEngine.StartExport.Headers=" + exportHeaders.toString());
            }
            this.buildExcelHeader((Workbook)wb, sheet, exportHeaders);
            long startExportTime = System.currentTimeMillis();
            long totalRowCount = this.buildExcelContentData(paramObj, (Workbook)wb, sheet, exportHeaders, excelExportConfig);
            this.autoResizeExcelColumnWidth(sheet, exportHeaders);
            long endExportTime = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("###ExportExcelEngine.startExport.ExportTotalData.UsedTime={}, TotalRowNum={}", (Object)(endExportTime - startExportTime), (Object)totalRowCount);
            }
            long exportDuration = endExportTime - startExportTime;
            String fullFileName = this.buildLocalTempExcelFile(excelExportConfig.getFileName(), excelExportConfig.getExcelFileType().toFileExt());
            long startSaveFile = System.currentTimeMillis();
            FileOutputStream fileOut = new FileOutputStream(fullFileName);
            wb.write((OutputStream)fileOut);
            long endSaveFile = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("###ExportExcelEngine.startExport.SaveExportFile.UsedTime=" + (endSaveFile - startSaveFile));
            }
            fileOut.close();
            String uploadSavePath = "export/" + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
            String afterUploadFileName = fullFileName;
            if (storageFileHelper != null) {
                afterUploadFileName = storageFileHelper.getDefaultStorageFileOperate().uploadFile(uploadSavePath, excelExportConfig.getFileName(), excelExportConfig.getExcelFileType().toFileExt(), fullFileName, excelExportConfig.getUserName());
            }
            ExportExcelResult exportExcelResult = new ExportExcelResult(true, "\u5bfc\u51fa\u6210\u529f", afterUploadFileName, fullFileName, totalRowCount, exportDuration);
            return exportExcelResult;
        }
        catch (Exception ex) {
            log.error("###ExportExcelEngine.startExport.Error###", (Throwable)ex);
            ExportExcelResult exportExcelResult = new ExportExcelResult(false, "\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef\uff1a" + ex.getMessage());
            return exportExcelResult;
        }
        finally {
            try {
                if (wb != null) {
                    wb.close();
                }
            }
            catch (IOException ex) {
                log.error("###ExportExcelEngine.startExport.close.Error###", (Throwable)ex);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ExportExcelResult startExportEasy(JSONObject paramObj, ExcelExportConfig excelExportConfig, List<ExcelHeadData> exportHeaders, StorageFileHelper storageFileHelper, ProgressHandler progressHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[TRYBLOCK]], but top level block is 55[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateProgress(ProgressHandler progressHandler, Long taskId, String content, Long alreadyFinishCount) {
        progressHandler.updateProgress(taskId, content, alreadyFinishCount);
    }

    private static String calculateUploadRate(double fileSizeMb, long timeSecond) {
        try {
            if (timeSecond == 0L) {
                return String.valueOf(fileSizeMb);
            }
            double rate = fileSizeMb / (double)timeSecond;
            return NumberUtil.decimalFormat((String)"#0.00", (Object)rate, (RoundingMode)RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            log.error("AbstractExcelExportEngine.calculateUploadRate.ERROR");
            return "";
        }
    }

    private String predictUploadTime(double fileSizeMb) {
        try {
            double fileUploadRate = 0.267;
            double timeSecond = fileSizeMb / fileUploadRate;
            Long timeS = new Long(new Double(timeSecond).longValue());
            if (timeS < 60L) {
                return timeS + "\u79d2";
            }
            long minute = timeS / 60L;
            return minute + "\u5206";
        }
        catch (Exception e) {
            log.error("AbstractExcelExportEngine.calculateUploadTime.ERROR", (Throwable)e);
            return "";
        }
    }

    private String calculatePercent(double x, double y) {
        if (y == 0.0) {
            return "";
        }
        double f = x * 100.0 / y;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(0);
        nf.setRoundingMode(RoundingMode.HALF_UP);
        nf.setGroupingUsed(true);
        return nf.format(f) + "%";
    }

    private List<List<String>> convertExcelHead(List<ExcelHeadData> exportHeaders, List<String> colList, List<Integer> decimalColumnIndexList, List<Integer> mergeColumnList) {
        ArrayList headList = ListUtils.newArrayList();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        exportHeaders.stream().forEach(excelHeadData -> {
            ArrayList headColumn = ListUtils.newArrayList();
            headColumn.add(excelHeadData.getName());
            headList.add(headColumn);
            colList.add(excelHeadData.getColname());
            if (excelHeadData.getType().equals(EXCEL_HEAD_DATA_TYPE_NUMBER)) {
                decimalColumnIndexList.add(atomicInteger.get());
            }
            if (Objects.equals(excelHeadData.isMerge(), true)) {
                mergeColumnList.add(atomicInteger.get());
            }
            atomicInteger.incrementAndGet();
        });
        return headList;
    }

    public long getExcelTotalRowCount(Workbook workbook) {
        int numberOfSheet = workbook.getNumberOfSheets();
        long totalRowCount = 0L;
        for (int i = 0; i < numberOfSheet; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            totalRowCount += (long)sheet.getLastRowNum();
        }
        return totalRowCount;
    }

    private long buildExcelContentData(JSONObject paramObj, Workbook wb, Sheet sheet, List<ExcelHeadData> exportHeaders, ExcelExportConfig excelExportConfig) throws IOException, InterruptedException {
        JSONObject copyParam = JSONObject.parseObject((String)paramObj.toJSONString());
        long totalRowCount = this.getTotalRowCount(paramObj);
        if (totalRowCount > 1000000L) {
            totalRowCount = 1000000L;
        }
        long pages = 1L;
        CellStyle strStyle = this.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_STRING);
        CellStyle numStyle = this.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_NUMBER);
        CellStyle intStyle = this.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_INTEGER);
        int page = 0;
        while ((long)page < pages) {
            int startindex = 500 * page;
            long startQueryData = System.currentTimeMillis();
            List<Map<String, Object>> rows = this.getContentDatas(copyParam);
            long endQueryData = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("###ExportExcelEngine.startExport.QueryExportData.UsedTime={};PageIndex={}", (Object)(endQueryData - startQueryData), (Object)page);
            }
            for (int row = 0; rows != null && row < rows.size(); ++row) {
                Map<String, Object> rs = rows.get(row);
                int rowIndex = page * 500 + row + 1;
                Row newExcelRow = sheet.createRow(rowIndex);
                block12: for (int col = 0; col < exportHeaders.size(); ++col) {
                    ExcelHeadData header = exportHeaders.get(col);
                    Cell cell = newExcelRow.createCell(col);
                    switch (header.getType()) {
                        case "STRING": {
                            this.parseCellStringType(strStyle, cell, rs, header);
                            continue block12;
                        }
                        case "INTEGER": {
                            this.parseCellNumberType(intStyle, cell, rs, header);
                            continue block12;
                        }
                        case "NUMBER": {
                            this.parseCellNumberType(numStyle, cell, rs, header);
                            continue block12;
                        }
                        default: {
                            if (!log.isWarnEnabled()) continue block12;
                            log.warn("###ExportExcelEngine.startExport.BuildRow.Type InValid. Row={}, Col={}", (Object)rowIndex, (Object)(col + 1));
                        }
                    }
                }
                if (excelExportConfig.getExcelFileType() == ExcelFileType.EXCEL2007 && row % 100 == 0 && sheet instanceof SXSSFSheet) {
                    ((SXSSFSheet)sheet).flushRows(100);
                }
                Thread.sleep(1L);
            }
            if (CollUtil.isNotEmpty(rows)) {
                rows.clear();
            }
            ++page;
        }
        return totalRowCount;
    }

    private void autoResizeExcelColumnWidth(Sheet sheet, List<ExcelHeadData> exportHeaders) {
        int i;
        HashMap<Integer, Integer> colMap = new HashMap<Integer, Integer>(exportHeaders.size());
        for (i = 0; i < exportHeaders.size(); ++i) {
            for (int j = 0; j <= sheet.getLastRowNum(); ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                Cell cell1 = row.getCell(i);
                String value = this.getCellValue(cell1);
                Integer columnSize = (Integer)colMap.get(i);
                if (value == null) continue;
                if (columnSize == null) {
                    colMap.put(i, value.getBytes().length);
                    continue;
                }
                if (value.getBytes().length <= columnSize) continue;
                colMap.put(i, value.getBytes().length);
            }
        }
        for (i = 0; i < exportHeaders.size(); ++i) {
            if ((Integer)colMap.get(i) * 256 * 2 >= 65280) continue;
            sheet.setColumnWidth(i, (Integer)colMap.get(i) * 256 * 2);
        }
    }

    private void buildExcelHeader(Workbook wb, Sheet sheet, List<ExcelHeadData> exportHeaders) {
        CellStyle headStyle = this.buildCellStyle(wb, true, false, EXCEL_HEAD_DATA_TYPE_STRING);
        Row newExcelRow = sheet.createRow(0);
        if (exportHeaders != null) {
            for (int i = 0; i < exportHeaders.size(); ++i) {
                ExcelHeadData header = exportHeaders.get(i);
                Cell cell = newExcelRow.createCell((int)((short)i));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(headStyle);
                String colName = header.getName();
                cell.setCellValue(colName);
            }
        }
    }

    private void parseCellNumberType(CellStyle numStyle, Cell cell, Map<String, Object> rs, ExcelHeadData header) {
        String columnName = header.getColname();
        String columnStrValue = this.formatDefaultDataValue(rs.get(columnName));
        if (rs.get(columnName) != null) {
            try {
                Object columnValue = rs.get(columnName);
                cell.setCellType(CellType.NUMERIC);
                cell.setCellStyle(numStyle);
                if (header.getType().equals(EXCEL_HEAD_DATA_TYPE_INTEGER)) {
                    if (columnStrValue.contains(".")) {
                        columnStrValue = StrUtil.subBefore((CharSequence)columnStrValue, (CharSequence)".", (boolean)true);
                    }
                    cell.setCellValue((double)Integer.parseInt(columnStrValue));
                } else if (header.getType().equals(EXCEL_HEAD_DATA_TYPE_NUMBER)) {
                    if (columnStrValue.contains(",")) {
                        columnStrValue = columnStrValue.replaceAll(",", "");
                    }
                    BigDecimal decimal = new BigDecimal(columnStrValue);
                    cell.setCellValue(decimal.doubleValue());
                } else {
                    cell.setCellValue(columnStrValue);
                }
            }
            catch (Exception e) {
                cell.setCellValue(columnStrValue);
            }
        }
    }

    private void parseCellStringType(CellStyle strStyle, Cell cell, Map<String, Object> rs, ExcelHeadData header) {
        String columnName = header.getColname();
        if (rs.get(columnName) != null) {
            String columnValue = this.formatDefaultDataValue(rs.get(columnName));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(strStyle);
            cell.setCellValue(columnValue);
        }
    }

    private String getCellValue(Cell cell) {
        if (cell.getCellType() == CellType.STRING) {
            return String.valueOf(cell.getStringCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return String.valueOf(cell.getStringCellValue());
    }

    private CellStyle buildCellStyle(Workbook wb, boolean isBold, boolean isNotNull, String type) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName(DEFAULT_EXCEL_FONT_NAME);
        if (isBold) {
            font.setColor(IndexedColors.DARK_BLUE.getIndex());
            font.setBold(true);
        }
        if (isNotNull) {
            font.setColor(IndexedColors.RED.getIndex());
        }
        CellStyle style = wb.createCellStyle();
        style.setFont(font);
        DataFormat format = wb.createDataFormat();
        if (StringUtils.equalsIgnoreCase((CharSequence)EXCEL_HEAD_DATA_TYPE_STRING, (CharSequence)type)) {
            style.setDataFormat(format.getFormat("text"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)EXCEL_HEAD_DATA_TYPE_INTEGER, (CharSequence)type)) {
            style.setDataFormat(format.getFormat("General"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)EXCEL_HEAD_DATA_TYPE_NUMBER, (CharSequence)type)) {
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        }
        return style;
    }

    private String formatDefaultDataValue(Object dataValue) {
        if (dataValue instanceof Date) {
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format((Date)dataValue);
        }
        if (dataValue instanceof LocalDateTime) {
            return LocalDateTimeUtil.format((LocalDateTime)((LocalDateTime)dataValue), (String)"yyyy-MM-dd HH:mm:ss");
        }
        return dataValue == null ? "" : dataValue.toString();
    }

    public String buildLocalTempExcelFile(String fileName, String fileExt) throws Exception {
        boolean mkResult;
        Object tempPath = ResourceUtils.getURL((String)"/home/admin/tmp").getPath();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String currentDate = FastDateFormat.getInstance((String)"yyyyMMdd").format(new Date());
        File savePathInfo = new File((String)(tempPath = (String)tempPath + File.separator + currentDate + File.separator + "export" + File.separator + uuid + File.separator));
        if (!savePathInfo.isDirectory() && !(mkResult = savePathInfo.mkdirs())) {
            throw new Exception("ExportExcelEngine.buildLocalTempExcelFile MkDir Failed");
        }
        return (String)tempPath + fileName + fileExt;
    }

    private boolean isAbortExportTask(Long taskId) {
        try {
            TaskInfo taskInfo = ExcelRedisHelper.selectTaskInfo(taskId);
            if (taskInfo == null) {
                log.info("AbstractExcelExportEngine.checkTaskStatus.taskInfo.null.taskId={}", (Object)taskId);
                return false;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)TaskInfo.ABORT)) {
                taskInfo.setAbortTime(new Date());
                ExcelRedisHelper.saveTask(taskId, taskInfo);
                log.info("AbstractExcelExportEngine.checkTaskStatus.taskInfo.abort.taskId={}", (Object)taskId);
                return true;
            }
        }
        catch (Exception e) {
            log.error("AbstractExcelExportEngine.checkTaskStatus.error", (Throwable)e);
        }
        return false;
    }

    public static void main(String[] args) {
        String aa = "{\"tableName\":\"sg_b_phy_in_notices\",\"jsonData\":{\"searchCondition\":[],\"pageSize\":20,\"pageIndex\":1}}\n";
        JSONObject jsonObject = JSON.parseObject((String)aa);
        jsonObject.getJSONObject("jsonData").remove((Object)"pageSize");
        jsonObject.getJSONObject("jsonData").remove((Object)"pageIndex");
        System.out.println();
    }
}

