/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.auth.LoginUserInfoHelper;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.excel.ExcelFileType;
import com.xinqiyi.framework.excel.ExportExcelResult;
import com.xinqiyi.framework.excel.handler.FileImportHandlerFactory;
import com.xinqiyi.framework.excel.model.FileType;
import com.xinqiyi.framework.excel.model.ImportEntity;
import com.xinqiyi.framework.excel.model.ImportErrorMsgDto;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import com.xinqiyi.framework.excel.model.ImportTransferResult;
import com.xinqiyi.framework.excel.util.ExcelExportUtils;
import com.xinqiyi.framework.excel.util.FileUploadUtils;
import com.xinqiyi.framework.file.StorageFileHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public abstract class AbstractExcelImportEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelImportEngine.class);
    private static final String ERROR_MSG_FORMAT = "\u5bfc\u5165\u6210\u529f%s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%s\u6761\uff0c\u5bfc\u5165\u5931\u8d25\u7684\u8bb0\u5f55\u8bf7\u4e0b\u8f7d\u6587\u4ef6\u67e5\u770b\u5bfc\u5165\u5931\u8d25\u539f\u56e0";

    protected abstract StorageFileHelper getStorageFileHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="dynamicAsyncExcelPoolTaskExecutor")
    @LogAnnotation
    public Future<ExportExcelResult> asyncStartImport(InputStream inputStream, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn) {
        ExportExcelResult excelResult;
        LoginUserInfo loginUserInfo = (LoginUserInfo)JSONObject.toJavaObject((JSON)masterTableConfig.getUserInfo(), LoginUserInfo.class);
        LoginUserInfoHelper.setLoginUserInfoThreadLocal((LoginUserInfo)loginUserInfo);
        try {
            excelResult = this.startImport(inputStream, masterTableConfig, slaveTableConfig, masterForeignColumn);
        }
        finally {
            LoginUserInfoHelper.removeLoginUserInfoThreadLocal();
        }
        return new AsyncResult((Object)excelResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LogAnnotation
    public ExportExcelResult startImport(InputStream inputStream, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn) {
        ArrayList<ImportErrorMsgDto> tempErrorList;
        ArrayList<Map<String, Object>> masterExcel2List;
        HashMap slaveExcel2Maps;
        ImportTransferResult masterConvertResult;
        ByteArrayOutputStream byteArrayOutputStream;
        ExportExcelResult excelResult;
        block37: {
            Iterator<Map<String, Object>> iterator;
            HashSet<Object> seen;
            block38: {
                if (log.isDebugEnabled()) {
                    log.debug("StartImport.MasterTableConfig=\u3010{}\u3011;SlaveTableConfig=\u3010{}\u3011;MasterForeignColumn=\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)masterTableConfig), JSONObject.toJSONString(slaveTableConfig), JSONObject.toJSONString((Object)masterTableConfig)});
                }
                excelResult = new ExportExcelResult();
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        long count;
                        Object tempIs2;
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = inputStream.read(buffer)) > -1) {
                            byteArrayOutputStream.write(buffer, 0, len);
                        }
                        byteArrayOutputStream.flush();
                        ByteArrayInputStream tempIs = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        masterConvertResult = this.convertImportExcel2Map(tempIs, masterTableConfig, masterTableConfig.getFileType());
                        ArrayList<ImportErrorMsgDto> failMsgList = masterConvertResult.isVerifyFail() ? masterConvertResult.getFailMsgList() : new ArrayList<ImportErrorMsgDto>();
                        slaveExcel2Maps = Maps.newHashMap();
                        if (slaveTableConfig != null) {
                            for (ImportTableConfig slaveTableInfo : slaveTableConfig) {
                                tempIs2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                                try {
                                    ImportTransferResult slaveConvertResult = this.convertImportExcel2Map((InputStream)tempIs2, slaveTableInfo, masterTableConfig.getFileType());
                                    slaveExcel2Maps.put(slaveConvertResult.getTableName(), slaveConvertResult.getList());
                                    if (!slaveConvertResult.isVerifyFail()) continue;
                                    failMsgList.addAll(slaveConvertResult.getFailMsgList());
                                }
                                finally {
                                    if (Collections.singletonList(tempIs2).get(0) == null) continue;
                                    ((InputStream)tempIs2).close();
                                }
                            }
                        }
                        if (CollectionUtils.isNotEmpty(failMsgList)) {
                            ByteArrayInputStream tempIs4 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                            try {
                                String path = this.handleFormatErrorMsgExport(masterTableConfig, slaveTableConfig, failMsgList, tempIs4);
                                excelResult.setSuccess(false);
                                excelResult.setMessage("\u5bfc\u5165\u5931\u8d25\uff1aexcel\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25");
                                excelResult.setExportFilePath(path);
                                tempIs2 = excelResult;
                                return tempIs2;
                            }
                            finally {
                                if (Collections.singletonList(tempIs4).get(0) != null) {
                                    ((InputStream)tempIs4).close();
                                }
                            }
                        }
                        boolean masterSheetAlone = true;
                        if (CollectionUtils.isNotEmpty(slaveTableConfig) && (count = slaveTableConfig.stream().filter(item -> item.getSheetNo() == masterTableConfig.getSheetNo()).count()) > 0L) {
                            masterSheetAlone = false;
                        }
                        masterExcel2List = new ArrayList();
                        tempErrorList = new ArrayList<ImportErrorMsgDto>();
                        if (null == masterForeignColumn) {
                            masterExcel2List = masterConvertResult.getList();
                            break block37;
                        }
                        if (masterSheetAlone) {
                            seen = new HashSet<Object>();
                            iterator = masterConvertResult.getList().iterator();
                            break block38;
                        }
                        masterExcel2List = masterConvertResult.getList().stream().filter(ExcelExportUtils.distinctByKey(b -> {
                            Object obj = b.get(masterForeignColumn.getName());
                            return this.transferInt2Str(obj);
                        })).collect(Collectors.toList());
                        break block37;
                        finally {
                            if (Collections.singletonList(tempIs).get(0) != null) {
                                ((InputStream)tempIs).close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(byteArrayOutputStream).get(0) != null) {
                            byteArrayOutputStream.close();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("###ExportImportEngine.startImport.Error###", (Throwable)e);
                    return new ExportExcelResult(false, "\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef\uff1a" + e.getMessage());
                }
            }
            while (iterator.hasNext()) {
                Map<String, Object> item2 = iterator.next();
                Object obj = item2.get(masterForeignColumn.getName());
                if (seen.contains(this.transferInt2Str(obj))) {
                    ImportErrorMsgDto errorMsgDto = new ImportErrorMsgDto(masterTableConfig.getSheetNo(), (Integer)item2.get("excelRowNum"), String.format("\u5f53\u524d\u6570\u636e\u7684\u552f\u4e00\u6807\u8bc6\u5217\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4", masterForeignColumn.getName()));
                    tempErrorList.add(errorMsgDto);
                    continue;
                }
                masterExcel2List.add(item2);
                seen.add(this.transferInt2Str(obj));
            }
        }
        ByteArrayInputStream tempIs4 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            FileImportHandlerFactory.getFileImportHandler(masterTableConfig.getFileType()).handleImageUpload(tempIs4, masterTableConfig, slaveTableConfig, this.getStorageFileHelper(), masterExcel2List, slaveExcel2Maps);
            List<ImportEntity> entityList = this.convert2EntityList(masterTableConfig, slaveTableConfig, masterForeignColumn, masterExcel2List, slaveExcel2Maps);
            excelResult.setTotalRowCount(entityList.size() + tempErrorList.size());
            List<ImportErrorMsgDto> failResultMsgList = this.saveEntity(masterTableConfig, slaveTableConfig, entityList);
            failResultMsgList.addAll(tempErrorList);
            excelResult.setSuccess(true);
            if (!CollectionUtils.isNotEmpty(failResultMsgList)) return excelResult;
            ByteArrayInputStream tempIs3 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            try {
                String path = this.handleBusinessErrorMsgExport(masterTableConfig, slaveTableConfig, masterForeignColumn, masterConvertResult, slaveExcel2Maps, failResultMsgList, tempIs3);
                excelResult.setExportFilePath(path);
                excelResult.setPartialSuccess(true);
                excelResult.setTotalRowCount(excelResult.getTotalRowCount() <= (long)failResultMsgList.size() ? 0L : excelResult.getTotalRowCount() - (long)failResultMsgList.size());
                excelResult.setMessage(String.format(ERROR_MSG_FORMAT, excelResult.getTotalRowCount(), failResultMsgList.size()));
                if (entityList.size() > failResultMsgList.size() - tempErrorList.size()) return excelResult;
                excelResult.setSuccess(false);
                excelResult.setPartialSuccess(false);
                excelResult.setMessage(String.format(ERROR_MSG_FORMAT, 0, failResultMsgList.size()));
                return excelResult;
            }
            finally {
                if (Collections.singletonList(tempIs3).get(0) != null) {
                    ((InputStream)tempIs3).close();
                }
            }
        }
        finally {
            if (Collections.singletonList(tempIs4).get(0) != null) {
                ((InputStream)tempIs4).close();
            }
        }
    }

    private Object transferInt2Str(Object obj) {
        if (obj instanceof Integer) {
            return String.valueOf(obj);
        }
        return obj;
    }

    private String handleFormatErrorMsgExport(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, List<ImportErrorMsgDto> failMsgList, InputStream inputStream) {
        return FileImportHandlerFactory.getFileImportHandler(masterTableConfig.getFileType()).exportFormatErrorMsg(masterTableConfig, slaveTableConfig, failMsgList, inputStream, this.getStorageFileHelper());
    }

    private String uploadWbFile(Workbook workbook, String username) {
        return FileUploadUtils.uploadFile("export", workbook, this.getStorageFileHelper(), "import-fail-mgs", "", ExcelFileType.EXCEL2007.toFileExt(), username);
    }

    private String handleBusinessErrorMsgExport(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn, ImportTransferResult masterConvertResult, Map<String, List<Map<String, Object>>> slaveExcel2Maps, List<ImportErrorMsgDto> failResultMsgList, InputStream inputStream) {
        return FileImportHandlerFactory.getFileImportHandler(masterTableConfig.getFileType()).exportBusinessErrorMsg(masterTableConfig, slaveTableConfig, masterForeignColumn, masterConvertResult, slaveExcel2Maps, failResultMsgList, inputStream, this.getStorageFileHelper());
    }

    protected abstract List<ImportErrorMsgDto> saveEntity(ImportTableConfig var1, List<ImportTableConfig> var2, List<ImportEntity> var3);

    public static boolean isJsonArray(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        try {
            JSONObject.parseArray((String)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<ImportEntity> convert2EntityList(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn, List<Map<String, Object>> masterDataList, Map<String, List<Map<String, Object>>> slaveTableDataMaps) {
        ArrayList<ImportEntity> result = new ArrayList<ImportEntity>();
        masterDataList.stream().forEach(map -> {
            ImportEntity assembleObject = new ImportEntity();
            assembleObject.setTableName(masterTableConfig.getTableName());
            assembleObject.setSheetNo(masterTableConfig.getSheetNo());
            JSONObject object = new JSONObject();
            masterTableConfig.getColumns().stream().forEach(entry -> {
                if (map.containsKey(entry.getName())) {
                    object.put(entry.getProperty(), map.get(entry.getName()));
                }
                if (StringUtils.isNotBlank((CharSequence)masterTableConfig.getMainDataColumnName())) {
                    object.put(masterTableConfig.getMainDataColumnName(), (Object)masterTableConfig.getMainDataValue());
                }
            });
            assembleObject.setRowNo((Integer)map.get("excelRowNum"));
            assembleObject.setMasterTable(object);
            if (slaveTableConfig != null) {
                ArrayList<ImportEntity.ImportChildEntity> child = new ArrayList<ImportEntity.ImportChildEntity>();
                slaveTableDataMaps.entrySet().forEach(entity -> {
                    ImportTableConfig importTable = slaveTableConfig.stream().filter(importTable1 -> importTable1.getTableName().equals(entity.getKey())).findFirst().orElse(null);
                    ImportTableConfig.ImportColumnConfig childForeignColumn = importTable.getColumns().stream().filter(a -> a.isForeign()).findFirst().orElse(null);
                    List<Map> childSalveList = ((List)entity.getValue()).stream().filter(slaveMap -> String.valueOf(map.get(masterForeignColumn.getName())).equals(String.valueOf(slaveMap.get(childForeignColumn.getName())))).collect(Collectors.toList());
                    ArrayList<JSONObject> childList = new ArrayList<JSONObject>();
                    childSalveList.forEach(slaveMap -> {
                        JSONObject childObject = new JSONObject();
                        importTable.getColumns().stream().forEach(entry -> {
                            if (slaveMap.containsKey(entry.getName()) && null != slaveMap.get(entry.getName())) {
                                childObject.put(entry.getProperty(), slaveMap.get(entry.getName()));
                            }
                        });
                        if (childObject.entrySet().size() > 1) {
                            childObject.put("excelRowNum", slaveMap.get("excelRowNum"));
                            childList.add(childObject);
                        }
                    });
                    if (CollectionUtils.isNotEmpty(childList)) {
                        ImportEntity.ImportChildEntity resultEntity = new ImportEntity.ImportChildEntity();
                        resultEntity.setTableName((String)entity.getKey());
                        resultEntity.setForeignKey(importTable.getForeignKey());
                        resultEntity.setData(childList);
                        resultEntity.setSheetNo(importTable.getSheetNo());
                        child.add(resultEntity);
                    }
                });
                assembleObject.setSlaveTable(child);
            }
            result.add(assembleObject);
        });
        return result;
    }

    private ImportTransferResult convertImportExcel2Map(InputStream inputStream, ImportTableConfig tableConfig, FileType fileType) {
        return FileImportHandlerFactory.getFileImportHandler(fileType).convertImportData(inputStream, tableConfig);
    }
}

