/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.auth.LoginUserInfoHelper;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.excel.AbstractExcelExportEngine;
import com.xinqiyi.framework.excel.ExcelExportConfig;
import com.xinqiyi.framework.excel.ExportExcelResult;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.framework.file.StorageFileHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public abstract class AbstractExcelTemplateExportEngine
extends AbstractExcelExportEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelTemplateExportEngine.class);

    @Override
    public int getTotalRowCount(JSONObject paramObj) {
        return 0;
    }

    @Override
    public List<Map<String, Object>> getContentDatas(JSONObject paramObj) {
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public List<ExcelHeadData> getExcelHeadData(JSONObject jsonObject) {
        return new ArrayList<ExcelHeadData>();
    }

    public abstract Map getContentData(JSONObject var1);

    public abstract String getTemplateFileFullPath(JSONObject var1);

    public ExportExcelResult startTemplateExport(ExcelExportConfig excelExportConfig, StorageFileHelper storageFileHelper, JSONObject paramObj) {
        Map dataMap = this.getContentData(paramObj);
        String templateFileFullPath = this.getTemplateFileFullPath(paramObj);
        return this.startTemplateExport(dataMap, templateFileFullPath, excelExportConfig, storageFileHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="dynamicAsyncExcelPoolTaskExecutor")
    public Future<ExportExcelResult> asyncStartTemplateExport(ExcelExportConfig excelExportConfig, StorageFileHelper storageFileHelper, JSONObject paramObj) {
        ExportExcelResult exportExcelResult = null;
        try {
            LoginUserInfo loginUserInfo;
            if (paramObj.containsKey((Object)"loginUserInfo")) {
                loginUserInfo = (LoginUserInfo)paramObj.getObject("loginUserInfo", LoginUserInfo.class);
                LoginUserInfoHelper.setLoginUserInfoThreadLocal((LoginUserInfo)loginUserInfo);
            }
            exportExcelResult = this.startTemplateExport(excelExportConfig, storageFileHelper, paramObj);
            loginUserInfo = new AsyncResult((Object)exportExcelResult);
            return loginUserInfo;
        }
        catch (Exception e) {
            log.error("AbstractExcelTemplateExportEngine.asyncStartTemplateExport.ERROR", (Throwable)e);
        }
        finally {
            exportExcelResult = new ExportExcelResult(false, "\u5f02\u6b65\u6a21\u677f\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef");
            LoginUserInfoHelper.removeLoginUserInfoThreadLocal();
        }
        return new AsyncResult((Object)exportExcelResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportExcelResult startTemplateExport(Map dataMap, String templateFileFullPath, ExcelExportConfig excelExportConfig, StorageFileHelper storageFileHelper) {
        String uploadSavePath = "export/" + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
        Workbook workbook = null;
        String outputFileFullPath = null;
        try {
            outputFileFullPath = this.buildLocalTempExcelFile(excelExportConfig.getFileName(), excelExportConfig.getExcelFileType().toFileExt());
        }
        catch (Exception e) {
            log.error("AbstractExcelTemplateExportEngine.startTemplateExport.buildLocalTempExcelFile.ERROR", (Throwable)e);
            return new ExportExcelResult(false, "\u5bfc\u51fa\u5931\u8d25,\u751f\u6210\u672c\u5730\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        try {
            ExportExcelResult exportExcelResult;
            FileOutputStream fos = new FileOutputStream(outputFileFullPath);
            try {
                long startExportTime = System.currentTimeMillis();
                TemplateExportParams exportParams = null;
                Class keyClass = null;
                Set s = dataMap.keySet();
                Iterator iterator = s.iterator();
                if (iterator.hasNext()) {
                    Object k = iterator.next();
                    keyClass = k.getClass();
                }
                if (keyClass == null) {
                    keyClass = String.class;
                }
                if (keyClass.equals(Integer.class)) {
                    Integer[] sheetNum = new Integer[dataMap.size()];
                    for (int i = 0; i < dataMap.size(); ++i) {
                        sheetNum[i] = i;
                    }
                    exportParams = new TemplateExportParams(templateFileFullPath, sheetNum);
                    workbook = ExcelExportUtil.exportExcel((Map)dataMap, (TemplateExportParams)exportParams);
                } else {
                    exportParams = new TemplateExportParams(templateFileFullPath, new Integer[0]);
                    workbook = ExcelExportUtil.exportExcel((TemplateExportParams)exportParams, (Map)dataMap);
                }
                workbook.write((OutputStream)fos);
                long totalRowCount = this.getExcelTotalRowCount(workbook);
                String afterUploadFileName = storageFileHelper.getDefaultStorageFileOperate().uploadFile(uploadSavePath, excelExportConfig.getFileName(), excelExportConfig.getExcelFileType().toFileExt(), outputFileFullPath, excelExportConfig.getUserName());
                long exportDuration = System.currentTimeMillis() - startExportTime;
                exportExcelResult = new ExportExcelResult(true, "\u5bfc\u51fa\u6210\u529f", afterUploadFileName, outputFileFullPath, totalRowCount, exportDuration);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("###AbstractExcelTemplateExportEngine.startTemplateExport.ERROR", (Throwable)e);
                    ExportExcelResult exportExcelResult2 = new ExportExcelResult(false, "\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e0d\u53ef\u77e5\u7684\u5f02\u5e38\u3002\u5f02\u5e38\u9519\u8bef\uff1a" + e.getMessage());
                    return exportExcelResult2;
                }
            }
            fos.close();
            return exportExcelResult;
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException ex) {
                log.error("###AbstractExcelTemplateExportEngine.startTemplateExport.close.Error###", (Throwable)ex);
            }
        }
    }
}

