/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import com.xinqiyi.framework.excel.ExcelThreadPoolTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ContextCopyingDecorator
implements TaskDecorator {
    private static final Logger log = LoggerFactory.getLogger(ContextCopyingDecorator.class);
    public ExcelThreadPoolTaskExecutor excelThreadPoolTaskExecutor;
    public static final String TASK_ID_NAME = "taskId";

    public ContextCopyingDecorator(ExcelThreadPoolTaskExecutor excelThreadPoolTaskExecutor) {
        this.excelThreadPoolTaskExecutor = excelThreadPoolTaskExecutor;
    }

    public ContextCopyingDecorator() {
    }

    public Runnable decorate(final Runnable runnable) {
        try {
            final RequestAttributes context = RequestContextHolder.currentRequestAttributes();
            Runnable decorateRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (context != null) {
                            RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                        }
                        runnable.run();
                    }
                    finally {
                        RequestContextHolder.resetRequestAttributes();
                    }
                }
            };
            return decorateRunnable;
        }
        catch (IllegalStateException e) {
            return runnable;
        }
    }
}

