/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelCellWriteHandler
implements CellWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcelCellWriteHandler.class);
    public List<ExcelHeadData> headDataList;
    public List<Integer> decimalColumnIndexList;
    private Integer totalRowCount;

    public ExcelCellWriteHandler(List<Integer> decimalColumnIndexList, Integer totalRowCount) {
        this.decimalColumnIndexList = decimalColumnIndexList;
        this.totalRowCount = totalRowCount;
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer integer, Boolean isHead) {
        try {
            if (!isHead.booleanValue() && CollUtil.contains(this.decimalColumnIndexList, (Object)cell.getColumnIndex())) {
                if (StringUtils.isBlank((CharSequence)cellData.getStringValue())) {
                    cellData.setStringValue("");
                } else {
                    BigDecimal val = new BigDecimal(cellData.getStringValue().replace(",", ""));
                    cellData.setType(CellDataTypeEnum.NUMBER);
                    cellData.setNumberValue(val);
                    if (writeSheetHolder.getSheet().getLastRowNum() > this.totalRowCount) {
                        log.info("afterCellDataConverted.lastRowIndex={},val={}", (Object)writeSheetHolder.getLastRowIndex(), (Object)val.toString());
                        cellData.setType(CellDataTypeEnum.STRING);
                        if (val.compareTo(BigDecimal.ZERO) == 0) {
                            val = BigDecimal.ZERO;
                        }
                        cellData.setStringValue(val.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            cellData.setStringValue(cellData.getStringValue());
            log.error("ExcelCellWriteHandler.afterCellDataConverted,cellData={}", (Object)JSON.toJSONString(cellData), (Object)e);
        }
    }
}

