/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFillCellRowMergeStrategy
implements CellWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcelFillCellRowMergeStrategy.class);
    private Integer[] mergeColumnIndex;
    private int mergeRowIndex;
    private Integer noMergeRowIndex;

    public ExcelFillCellRowMergeStrategy() {
    }

    public ExcelFillCellRowMergeStrategy(int mergeRowIndex, Integer[] mergeColumnIndex) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public ExcelFillCellRowMergeStrategy(int mergeRowIndex, Integer[] mergeColumnIndex, Integer noMergeRowIndex) {
        this.mergeColumnIndex = mergeColumnIndex;
        this.mergeRowIndex = mergeRowIndex;
        this.noMergeRowIndex = noMergeRowIndex;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        if (curRowIndex > this.mergeRowIndex) {
            for (int i = 0; i < this.mergeColumnIndex.length; ++i) {
                if (curColIndex != this.mergeColumnIndex[i]) continue;
                this.mergeWithPrevRow(writeSheetHolder, cell, curRowIndex, curColIndex);
                break;
            }
        }
    }

    private void mergeWithPrevRow(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex) {
        Cell preCell;
        Object preData;
        Object curData = cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : Double.valueOf(cell.getNumericCellValue());
        Row preRow = cell.getSheet().getRow(curRowIndex - 1);
        if (preRow == null) {
            preRow = writeSheetHolder.getCachedSheet().getRow(curRowIndex - 1);
        }
        Object object = preData = (preCell = preRow.getCell(curColIndex)).getCellType() == CellType.STRING ? preCell.getStringCellValue() : Double.valueOf(preCell.getNumericCellValue());
        if (this.noMergeRowIndex != null && this.noMergeRowIndex == curRowIndex - 1) {
            return;
        }
        boolean dataBool = preData.equals(curData);
        if (dataBool) {
            Sheet sheet = writeSheetHolder.getSheet();
            List mergeRegions = sheet.getMergedRegions();
            boolean isMerged = false;
            for (int i = 0; i < mergeRegions.size() && !isMerged; ++i) {
                CellRangeAddress cellRangeAddr = (CellRangeAddress)mergeRegions.get(i);
                if (!cellRangeAddr.isInRange(curRowIndex - 1, curColIndex)) continue;
                sheet.removeMergedRegion(i);
                cellRangeAddr.setLastRow(curRowIndex);
                sheet.addMergedRegion(cellRangeAddr);
                isMerged = true;
            }
            if (!isMerged) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex - 1, curRowIndex, curColIndex, curColIndex);
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
    }
}

