/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ExcelThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExcelThreadPoolTaskExecutor.class);
    private static final Map<Long, Runnable> cache = new HashMap<Long, Runnable>();

    public void cancelRemainingTask(Long taskId) {
        try {
            Runnable runnable = cache.get(taskId);
            if (runnable != null) {
                super.cancelRemainingTask(runnable);
                Thread.currentThread().interrupt();
                if (log.isDebugEnabled()) {
                    log.debug("ExcelThreadPoolTaskExecutor.cancelRemainingTask.id={},runable={},cache={}", new Object[]{taskId, runnable, JSON.toJSONString(cache)});
                }
            }
        }
        catch (Exception e) {
            log.error("ExcelThreadPoolTaskExecutor.cancelRemainingTask", (Throwable)e);
        }
    }

    public void addRunnable(Long taskId, Runnable runnable) {
        cache.put(taskId, runnable);
        if (log.isDebugEnabled()) {
            log.debug("ExcelThreadPoolTaskExecutor.taskId={},addRunnable={}", (Object)taskId, (Object)runnable);
        }
    }
}

