/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.config;

import com.xinqiyi.framework.excel.ContextCopyingDecorator;
import com.xinqiyi.framework.excel.ExcelThreadPoolTaskExecutor;
import com.xinqiyi.framework.excel.config.DynamicExcelConfig;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DynamicThreadPoolConfig {
    @Bean(name={"dynamicAsyncExcelPoolTaskExecutor"})
    public ExcelThreadPoolTaskExecutor asyncThreadPoolTaskExecutor(DynamicExcelConfig dynamicExcelConfig) {
        ExcelThreadPoolTaskExecutor taskExecutor = new ExcelThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(dynamicExcelConfig.getCorePoolSize());
        taskExecutor.setQueueCapacity(dynamicExcelConfig.getQueueCapacity());
        taskExecutor.setMaxPoolSize(dynamicExcelConfig.getMaxPoolSize());
        taskExecutor.setKeepAliveSeconds(dynamicExcelConfig.getKeepAliveSeconds());
        taskExecutor.setThreadNamePrefix("excel-");
        taskExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        taskExecutor.setTaskDecorator(new ContextCopyingDecorator(taskExecutor));
        taskExecutor.initialize();
        return taskExecutor;
    }
}

