/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.handler;

import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHandlerResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import com.xinqiyi.framework.excel.handler.ExcelImportConfigHelper;
import com.xinqiyi.framework.excel.model.ImportColumnDataType;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelVerifyHandler<T>
implements IExcelVerifyHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelVerifyHandler.class);
    public static final String NOT_EXIST = "\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528";
    public static final String NOT_BLANK = "\u4e0d\u80fd\u4e3a\u7a7a";
    public static final String NEED_BLANK = "\u5fc5\u987b\u4e3a\u7a7a";
    public static final String ILLEGAL_INPUT = "\u975e\u6cd5\u8f93\u5165";
    public static final String ILLEGAL_PATTERN = "\u6b63\u5219\u683c\u5f0f\u6821\u9a8c\u5931\u8d25";
    public static final String ILLEGAL_TYPE = "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef";
    public static final String ILLEGAL_TYPE_INTEGER = "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6574\u578b";
    public static final String ILLEGAL_TYPE_DECIMAL = "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6570\u503c\u7c7b\u578b";
    private static final String ILLEGAL_ENUM = "\u679a\u4e3e\u9519\u8bef";
    public static final String EXCEL_ROW_NUM = "excelRowNum";
    public static final String EXCEL_ERROR_MSG = "excelErrorMsg";
    public static final String COMMA_CHAR = ",";

    @PostConstruct
    abstract void init();

    abstract void verify(T var1);

    public ExcelVerifyHandlerResult verifyHandler(T obj) {
        ExcelImportConfigHelper.setErrorMsg(new StringBuilder());
        ImportTableConfig config = this.getCurrentTableConfig();
        if (obj instanceof Map) {
            ((Map)obj).forEach((columnTitle, columnValue) -> ((Map)obj).put(columnTitle, AbstractExcelVerifyHandler.transferObjectValue(columnTitle, columnValue, config)));
        }
        this.verify(obj);
        return this.checkResult();
    }

    public static Object transferObjectValue(String columnTitle, Object obj, ImportTableConfig config) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return obj;
        }
        if (obj instanceof Double) {
            return new BigDecimal(String.valueOf(obj)).stripTrailingZeros().toPlainString();
        }
        if (obj instanceof Date) {
            return DateUtil.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (obj instanceof String) {
            obj = String.valueOf(obj).trim();
            ImportTableConfig.ImportColumnConfig importColumnConfig = null;
            if (ObjectUtils.isNotEmpty((Object)config)) {
                importColumnConfig = config.getColumns().stream().filter(item -> StringUtils.equals((CharSequence)columnTitle, (CharSequence)item.getName())).findAny().orElse(null);
            }
            if (null != importColumnConfig && null != importColumnConfig.getDataType() && StringUtils.equals((CharSequence)importColumnConfig.getDataType().getCode(), (CharSequence)ImportColumnDataType.DECIMAL.getCode())) {
                obj = String.valueOf(obj).replace(COMMA_CHAR, "");
            }
        }
        return obj;
    }

    protected ExcelVerifyHandlerResult checkResult() {
        StringBuilder errorMsg = ExcelImportConfigHelper.getErrorMsg();
        if (errorMsg.length() <= 0) {
            return new ExcelVerifyHandlerResult(true, null);
        }
        ExcelImportConfigHelper.removeErrorMsg();
        return new ExcelVerifyHandlerResult(false, errorMsg.substring(0, errorMsg.length() - 1) + "\n");
    }

    protected <E> Optional<E> checkExist(Collection<E> list, Predicate<? super E> predicate, String field) {
        return this.checkExist(list, predicate, field, NOT_EXIST);
    }

    protected <T> Optional<T> checkExist(Collection<T> list, Predicate<? super T> predicate, String field, String msg) {
        Optional<T> optional = list.stream().filter(predicate).findFirst();
        if (!optional.isPresent()) {
            this.appendErrorMsg(field, msg);
        }
        return optional;
    }

    protected void appendErrorMsg(String field, String msg) {
        StringBuilder errorMsg = ExcelImportConfigHelper.getErrorMsg();
        if (CharSequenceUtil.isNotBlank((CharSequence)field)) {
            errorMsg.append("\u3010").append(field).append("\u3011: ");
        }
        errorMsg.append(msg).append("; ");
        ExcelImportConfigHelper.setErrorMsg(errorMsg);
    }

    protected void appendEnumErrorMsg(String field) {
        this.appendErrorMsg(field, ILLEGAL_ENUM);
    }

    protected void checkBlank(String value, String field, boolean needBlank) {
        if (needBlank && CharSequenceUtil.isNotBlank((CharSequence)value)) {
            this.appendErrorMsg(field, NEED_BLANK);
        } else if (!needBlank && CharSequenceUtil.isBlank((CharSequence)value)) {
            this.appendErrorMsg(field, NOT_BLANK);
        }
    }

    protected boolean checkNonNull(Object value, String field) {
        if (ObjectUtil.isEmpty((Object)value)) {
            this.checkNonNull(value, field, NOT_BLANK);
            return false;
        }
        return true;
    }

    protected boolean checkNonNull(Object value, String field, String msg) {
        if (ObjectUtil.isEmpty((Object)value)) {
            this.appendErrorMsg(field, msg);
            return false;
        }
        return true;
    }

    protected boolean checkPattern(String pattern, Object value, String field, String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            msg = ILLEGAL_PATTERN;
        }
        String valueStr = "";
        if (value instanceof Double) {
            valueStr = BigDecimal.valueOf((Double)value).toPlainString();
        } else if (value instanceof String) {
            valueStr = (String)value;
        } else if (value instanceof Integer) {
            valueStr = String.valueOf(value);
        } else {
            this.appendErrorMsg(field, ILLEGAL_TYPE);
            return false;
        }
        if (!ReUtil.isMatch((String)pattern, (CharSequence)valueStr)) {
            this.appendErrorMsg(field, msg);
            return false;
        }
        return true;
    }

    protected void checkEquals(Object value1, Object value2, String msg) {
        if (ObjectUtil.notEqual((Object)value1, (Object)value2)) {
            this.appendErrorMsg(null, msg);
        }
    }

    public void setCurrentTableConfig(ImportTableConfig config) {
        ExcelImportConfigHelper.setCurrentTableConfig(config);
    }

    public ImportTableConfig getCurrentTableConfig() {
        return ExcelImportConfigHelper.getCurrentTableConfig();
    }

    public void clearCurrentTableConfig() {
        ExcelImportConfigHelper.removeTableConfig();
    }
}

