/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.handler;

import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHandlerResult;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.excel.handler.AbstractExcelVerifyHandler;
import com.xinqiyi.framework.excel.handler.AbstractFileImportHandler;
import com.xinqiyi.framework.excel.model.ImportErrorMsgDto;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import com.xinqiyi.framework.excel.model.ImportTransferResult;
import com.xinqiyi.framework.excel.util.FileUploadUtils;
import com.xinqiyi.framework.file.StorageFileHelper;
import com.xinqiyi.framework.util.ApplicationContextHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CsvFileImportHandler
extends AbstractFileImportHandler {
    private static final Logger log = LoggerFactory.getLogger(CsvFileImportHandler.class);
    public static final String CHAR_SET_GB2312 = "GB2312";
    public static final String FILE_SUFFIX = ".csv";

    @Override
    public ImportTransferResult convertImportData(InputStream inputStream, ImportTableConfig tableConfig) {
        ImportTransferResult convertResult = new ImportTransferResult();
        convertResult.setTableName(tableConfig.getTableName());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CHAR_SET_GB2312));
        String line = null;
        int titleRow = tableConfig.getTitleRow() + 1;
        int contentRow = tableConfig.getTitleRow() + 1 + tableConfig.getStartRow() + 1;
        int position = 0;
        Map<Object, Object> titleMap = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        ArrayList<ImportErrorMsgDto> failMsgList = new ArrayList<ImportErrorMsgDto>();
        while ((line = reader.readLine()) != null) {
            String[] contents;
            if (++position < titleRow || (contents = line.split(",")).length == 0) continue;
            if (position == titleRow) {
                titleMap = this.getTitleMap(contents);
                continue;
            }
            if (position < contentRow) continue;
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("excelRowNum", position);
            boolean verify = this.verifyData(dataMap, contents, titleMap, tableConfig);
            if (verify) {
                list.add(dataMap);
                continue;
            }
            failList.add(dataMap);
            String errorMsg = (String)dataMap.get("excelErrorMsg");
            ImportErrorMsgDto errorMsgDto = new ImportErrorMsgDto();
            errorMsgDto.setSheetNo(tableConfig.getSheetNo());
            errorMsgDto.setRowNo(position);
            errorMsgDto.setErrorMsg(errorMsg);
            errorMsgDto.setValue(JSON.toJSONString((Object)dataMap));
            failMsgList.add(errorMsgDto);
        }
        convertResult.setList(list);
        convertResult.setFailList(failList);
        convertResult.setVerifyFail(CollectionUtils.isNotEmpty((Collection)failList));
        convertResult.setFailMsgList(failMsgList);
        return convertResult;
    }

    @Override
    public String exportFormatErrorMsg(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, List<ImportErrorMsgDto> failMsgList, InputStream inputStream, StorageFileHelper storageFileHelper) {
        return this.uploadErrorMsg(masterTableConfig, failMsgList, inputStream, storageFileHelper, false);
    }

    @Override
    public String exportBusinessErrorMsg(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn, ImportTransferResult masterDataResult, Map<String, List<Map<String, Object>>> slaveDataMaps, List<ImportErrorMsgDto> failMsgList, InputStream inputStream, StorageFileHelper storageFileHelper) {
        return this.uploadErrorMsg(masterTableConfig, failMsgList, inputStream, storageFileHelper, true);
    }

    @Override
    public void handleImageUpload(InputStream in, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfigList, StorageFileHelper storageFileHelper, List<Map<String, Object>> masterDataList, Map<String, List<Map<String, Object>>> slaveDataMaps) {
    }

    private String uploadErrorMsg(ImportTableConfig masterTableConfig, List<ImportErrorMsgDto> failMsgList, InputStream inputStream, StorageFileHelper storageFileHelper, boolean removeNoErrorRow) {
        String afterUploadFileName = null;
        try {
            Map<Integer, String> errorMsgDtoMap = failMsgList.stream().collect(Collectors.toMap(ImportErrorMsgDto::getRowNo, ImportErrorMsgDto::getErrorMsg, (a, b) -> b));
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CHAR_SET_GB2312));
            String fullFileName = FileUploadUtils.buildLocalTempExcelFile("temp", FILE_SUFFIX);
            File dest = new File(fullFileName);
            BufferedWriter bw = new BufferedWriter(new FileWriter(dest));
            String line = null;
            int titleRow = masterTableConfig.getTitleRow() + 1;
            int contentRow = masterTableConfig.getTitleRow() + 1 + masterTableConfig.getStartRow() + 1;
            int position = 0;
            while ((line = reader.readLine()) != null) {
                ++position;
                StringBuilder sb = new StringBuilder();
                sb.append(line);
                sb.append(",");
                if (position == titleRow) {
                    sb.append("\u5f02\u5e38\u4fe1\u606f");
                } else if (position >= contentRow) {
                    String errorMsg = errorMsgDtoMap.get(position);
                    if (removeNoErrorRow && null == errorMsg) continue;
                    sb.append(StringUtils.isNotBlank((CharSequence)errorMsg) ? errorMsg : "");
                }
                bw.write(sb.toString());
                bw.newLine();
                bw.flush();
            }
            String username = masterTableConfig.getUserInfo() != null ? masterTableConfig.getUserInfo().getString("userName") : "";
            String uploadSavePath = FileUploadUtils.getFileDirectoryPrefix("export");
            afterUploadFileName = storageFileHelper.getDefaultStorageFileOperate().uploadFile(uploadSavePath, FileUploadUtils.getUploadSaveFileName("import-fail-mgs", "").toString(), FILE_SUFFIX, fullFileName, username);
            dest.delete();
            bw.close();
        }
        catch (Exception e) {
            log.error("CsvFileImportHandler.exportFormatErrorMsg.Error.\u5bfc\u51fa\u683c\u5f0f\u9519\u8bef\u7684Excel\u5f02\u5e38", (Throwable)e);
        }
        return afterUploadFileName;
    }

    private boolean verifyData(Map<String, Object> dataMap, String[] contents, Map<Integer, String> titleMap, ImportTableConfig tableConfig) {
        for (int i = 0; i < contents.length; ++i) {
            dataMap.put(titleMap.get(i), contents[i]);
        }
        AbstractExcelVerifyHandler verifyHandler = StringUtils.isNotBlank((CharSequence)tableConfig.getVerifyHandler()) ? (AbstractExcelVerifyHandler)ApplicationContextHelper.getBean((String)tableConfig.getVerifyHandler()) : (AbstractExcelVerifyHandler)ApplicationContextHelper.getBean((String)"dynamicExcelVerifyHandler");
        verifyHandler.setCurrentTableConfig(tableConfig);
        ExcelVerifyHandlerResult excelVerifyHandlerResult = verifyHandler.verifyHandler(dataMap);
        verifyHandler.clearCurrentTableConfig();
        dataMap.put("excelErrorMsg", excelVerifyHandlerResult.getMsg());
        return excelVerifyHandlerResult.isSuccess();
    }

    private Map<Integer, String> getTitleMap(String[] contents) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < contents.length; ++i) {
            map.put(i, contents[i]);
        }
        return map;
    }

    @Override
    public void checkTitle(InputStream inputStream, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig) {
        HashSet<Integer> sheetNos = new HashSet<Integer>();
        sheetNos.add(masterTableConfig.getSheetNo());
        if (CollectionUtils.isNotEmpty(slaveTableConfig)) {
            slaveTableConfig.forEach(item -> sheetNos.add(item.getSheetNo()));
        }
        Assert.isTrue((sheetNos.size() <= 1 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, CSV\u7c7b\u578b\u6587\u4ef6\u4e0d\u652f\u6301\u591asheet\u914d\u7f6e");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CHAR_SET_GB2312));
        String line = null;
        int titleRow = masterTableConfig.getTitleRow() + 1;
        int position = 1;
        String[] headers = null;
        while ((line = reader.readLine()) != null) {
            if (position == titleRow) {
                headers = line.split(",");
                break;
            }
            ++position;
        }
        Assert.isTrue((position == titleRow && null != headers && headers.length > 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u6587\u4ef6\u4e0d\u5b58\u5728\u6807\u9898\u884c");
        HashSet<String> headerSet = new HashSet<String>();
        for (int i = 0; i < headers.length; ++i) {
            String temp = headers[i];
            if (temp == "") continue;
            if (headerSet.contains(temp)) {
                throw new IllegalArgumentException(String.format("\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u6807\u9898\u91cd\u590d: %s", temp));
            }
            headerSet.add(temp);
        }
        CsvFileImportHandler.checkCsvTitleByConfig(headerSet, masterTableConfig);
        if (CollectionUtils.isNotEmpty(slaveTableConfig)) {
            slaveTableConfig.forEach(item -> CsvFileImportHandler.checkCsvTitleByConfig(headerSet, item));
        }
    }

    private static void checkCsvTitleByConfig(Set<String> headerSet, ImportTableConfig config) {
        config.getColumns().forEach(item -> {
            if (item.getIsNotNull().booleanValue() && !headerSet.contains(item.getName())) {
                String format = "\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u8868\u540d\u3010%s\u3011\u7684\u914d\u7f6e, \u7b2c\u3010%s\u3011sheet\u4e2d\u4e0d\u5b58\u5728\u6807\u9898\u4e3a\u3010%s\u3011\u7684\u5355\u5143\u5217\uff0c\u8bf7\u786e\u8ba4";
                throw new IllegalArgumentException(String.format(format, config.getTableName(), config.getSheetNo(), item.getName()));
            }
        });
    }
}

