/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.handler;

import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.framework.excel.handler.AbstractExcelVerifyHandler;
import com.xinqiyi.framework.excel.handler.ExcelImportConfigHelper;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="dynamicExcelVerifyHandler")
public class DynamicExcelVerifyHandler
extends AbstractExcelVerifyHandler<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(DynamicExcelVerifyHandler.class);

    @Override
    protected void init() {
    }

    @Override
    protected void verify(Map<String, Object> obj) {
        ImportTableConfig config = this.getCurrentTableConfig();
        if (null != config) {
            config.getColumns().forEach(columnConfig -> {
                Object column = obj.get(columnConfig.getName());
                if (null != columnConfig.getIsNotNull() && columnConfig.getIsNotNull().booleanValue()) {
                    this.checkNonNull(column, columnConfig.getName());
                }
                if (null != column) {
                    this.checkDataType((ImportTableConfig.ImportColumnConfig)columnConfig, column);
                    this.checkColumnLength((ImportTableConfig.ImportColumnConfig)columnConfig, column);
                    if (null != columnConfig.getPattern()) {
                        this.checkPattern(columnConfig.getPattern().getPattern(), column, columnConfig.getName(), columnConfig.getPattern().getMsg());
                    }
                }
                if (null != columnConfig.getEnumMap()) {
                    Object transferValue = columnConfig.transfer2EnumValue(column);
                    if (null == transferValue) {
                        this.appendEnumErrorMsg(columnConfig.getName());
                    } else if (!"".equals(transferValue)) {
                        obj.put(columnConfig.getName(), transferValue);
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)columnConfig.getDefaultValue()) && ObjectUtils.isEmpty(column) && StringUtils.isBlank((CharSequence)ExcelImportConfigHelper.getErrorMsg())) {
                    obj.put(columnConfig.getName(), columnConfig.getDefaultValue());
                }
            });
        }
        this.extraVerify(obj);
    }

    private void checkColumnLength(ImportTableConfig.ImportColumnConfig columnConfig, Object column) {
        if (!(column instanceof String)) {
            return;
        }
        String value = String.valueOf(column);
        if (ObjectUtil.isNotNull((Object)columnConfig.getMinLength()) && value.length() < columnConfig.getMinLength()) {
            this.appendErrorMsg(columnConfig.getName(), "\u6587\u672c\u957f\u5ea6\u5c0f\u4e8e\u6700\u5c0f\u957f\u5ea6\u9650\u5236: " + columnConfig.getMinLength());
        }
        if (ObjectUtil.isNotNull((Object)columnConfig.getMaxLength()) && value.length() > columnConfig.getMaxLength()) {
            this.appendErrorMsg(columnConfig.getName(), "\u6587\u672c\u957f\u5ea6\u5927\u4e8e\u6700\u5927\u957f\u5ea6\u9650\u5236: " + columnConfig.getMaxLength());
        }
    }

    private void checkDataType(ImportTableConfig.ImportColumnConfig columnConfig, Object column) {
        if (null == columnConfig.getDataType()) {
            return;
        }
        switch (columnConfig.getDataType()) {
            case DECIMAL: {
                if (column instanceof String) {
                    try {
                        Double.parseDouble(String.valueOf(column));
                    }
                    catch (Exception e) {
                        this.appendErrorMsg(columnConfig.getName(), "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6570\u503c\u7c7b\u578b");
                    }
                    break;
                }
                if (column instanceof Integer || column instanceof Double || column instanceof BigDecimal) break;
                this.appendErrorMsg(columnConfig.getName(), "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6570\u503c\u7c7b\u578b");
                break;
            }
            case INTEGER: {
                if (column instanceof String) {
                    try {
                        Integer.parseInt(String.valueOf(column));
                    }
                    catch (Exception e) {
                        this.appendErrorMsg(columnConfig.getName(), "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6574\u578b");
                    }
                    break;
                }
                if (column instanceof Integer) break;
                this.appendErrorMsg(columnConfig.getName(), "\u5355\u5143\u683c\u7c7b\u578b\u9519\u8bef: \u7c7b\u578b\u975e\u6574\u578b");
                break;
            }
        }
    }

    protected void extraVerify(Map<String, Object> obj) {
    }
}

