/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.handler;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.excel.ExcelFileType;
import com.xinqiyi.framework.excel.handler.AbstractExcelVerifyHandler;
import com.xinqiyi.framework.excel.handler.AbstractFileImportHandler;
import com.xinqiyi.framework.excel.model.ImportColumnDataType;
import com.xinqiyi.framework.excel.model.ImportErrorMsgDto;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import com.xinqiyi.framework.excel.model.ImportTransferResult;
import com.xinqiyi.framework.excel.util.ExcelExportUtils;
import com.xinqiyi.framework.excel.util.FileUploadUtils;
import com.xinqiyi.framework.file.StorageFileHelper;
import com.xinqiyi.framework.util.ApplicationContextHelper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFileImportHandler
extends AbstractFileImportHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcelFileImportHandler.class);

    @Override
    public ImportTransferResult convertImportData(InputStream inputStream, ImportTableConfig tableConfig) {
        AbstractExcelVerifyHandler verifyHandler;
        ImportTransferResult convertResult;
        block7: {
            ExcelImportResult result;
            ImportParams params;
            block6: {
                Integer lastRowNum;
                convertResult = new ImportTransferResult();
                convertResult.setTableName(tableConfig.getTableName());
                params = new ImportParams();
                params.setTitleRows(tableConfig.getTitleRow());
                params.setStartRows(tableConfig.getStartRow());
                params.setStartSheetIndex(tableConfig.getSheetNo());
                params.setNeedVerify(true);
                String[] importFields = tableConfig.getNotNullColumnNames();
                if (null != importFields) {
                    params.setImportFields(importFields);
                }
                verifyHandler = StringUtils.isNotBlank((CharSequence)tableConfig.getVerifyHandler()) ? (AbstractExcelVerifyHandler)ApplicationContextHelper.getBean((String)tableConfig.getVerifyHandler()) : (AbstractExcelVerifyHandler)ApplicationContextHelper.getBean((String)"dynamicExcelVerifyHandler");
                verifyHandler.setCurrentTableConfig(tableConfig);
                params.setVerifyHandler((IExcelVerifyHandler)verifyHandler);
                result = ExcelImportUtil.importExcelMore((InputStream)inputStream, Map.class, (ImportParams)params);
                convertResult.buildInfo((ExcelImportResult<Map<String, Object>>)result);
                boolean verifyFail = result.isVerifyFail();
                if (!verifyFail) break block6;
                ArrayList<ImportErrorMsgDto> failMsgList = new ArrayList<ImportErrorMsgDto>();
                for (Map dto : result.getFailList()) {
                    if (this.checkExcelLineSingleTableAllBlank(dto, tableConfig)) continue;
                    Integer rowNum = (Integer)dto.get("excelRowNum");
                    if (null == rowNum) {
                        rowNum = this.getExcelLastRowNo(tableConfig, (ExcelImportResult<Map<String, Object>>)result);
                    }
                    String errorMsg = (String)dto.get("excelErrorMsg");
                    ImportErrorMsgDto errorMsgDto = new ImportErrorMsgDto();
                    errorMsgDto.setSheetNo(tableConfig.getSheetNo());
                    errorMsgDto.setRowNo(rowNum);
                    errorMsgDto.setErrorMsg(errorMsg);
                    dto.remove("excelRowNum");
                    dto.remove("excelErrorMsg");
                    errorMsgDto.setValue(JSON.toJSONString((Object)dto));
                    failMsgList.add(errorMsgDto);
                }
                convertResult.setFailMsgList(failMsgList);
                if (!CollectionUtils.isEmpty(failMsgList) || !CollectionUtils.isNotEmpty((Collection)result.getList())) break block7;
                convertResult.setVerifyFail(false);
                Map lastLine = (Map)result.getList().get(result.getList().size() - 1);
                if (null == lastLine || null != (lastRowNum = (Integer)lastLine.get("excelRowNum"))) break block7;
                ((Map)result.getList().get(result.getList().size() - 1)).put("excelRowNum", this.getExcelLastRowNo(tableConfig, (ExcelImportResult<Map<String, Object>>)result));
                break block7;
            }
            for (int i = 0; i < result.getList().size(); ++i) {
                ((Map)result.getList().get(i)).put("excelRowNum", i + params.getTitleRows() + 1 + params.getStartRows() + 1);
            }
        }
        verifyHandler.clearCurrentTableConfig();
        return convertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportFormatErrorMsg(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, List<ImportErrorMsgDto> failMsgList, InputStream inputStream, StorageFileHelper storageFileHelper) {
        String string;
        block7: {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            try {
                Map<Integer, List<ImportErrorMsgDto>> groupErrorMsgMap = failMsgList.stream().collect(Collectors.groupingBy(ImportErrorMsgDto::getSheetNo));
                for (Integer sheetNo : groupErrorMsgMap.keySet()) {
                    List<ImportErrorMsgDto> sheetErrorMsgList = groupErrorMsgMap.get(sheetNo);
                    HashMap errorMsgMap = Maps.newHashMap();
                    sheetErrorMsgList.stream().forEach(errorMsgDto -> errorMsgMap.put(errorMsgDto.getRowNo(), errorMsgDto));
                    ImportTableConfig config = masterTableConfig.getSheetNo() == sheetNo.intValue() ? masterTableConfig : (ImportTableConfig)slaveTableConfig.stream().filter(c -> c.getSheetNo() == sheetNo.intValue()).findFirst().orElse(null);
                    ExcelExportUtils.appendErrorMsg(workbook, config, errorMsgMap);
                }
                String username = masterTableConfig.getUserInfo() != null ? masterTableConfig.getUserInfo().getString("userName") : "";
                string = this.uploadWbFile(workbook, username, storageFileHelper);
                if (Collections.singletonList(workbook).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
                throw throwable;
            }
            workbook.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportBusinessErrorMsg(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, ImportTableConfig.ImportColumnConfig masterForeignColumn, ImportTransferResult masterDataResult, Map<String, List<Map<String, Object>>> slaveDataMaps, List<ImportErrorMsgDto> failMsgList, InputStream inputStream, StorageFileHelper storageFileHelper) {
        String string;
        block9: {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            try {
                if (CollectionUtils.isNotEmpty(slaveTableConfig)) {
                    HashMap masterCodes = Maps.newHashMap();
                    HashMap slaveErrorMsgSheetMap = Maps.newHashMap();
                    masterDataResult.getList().stream().forEach(m -> {
                        Integer num = (Integer)m.get("excelRowNum");
                        for (ImportErrorMsgDto msg : failMsgList) {
                            if (!msg.getRowNo().equals(num)) continue;
                            masterCodes.put(this.getStringValue(m.get(masterForeignColumn.getName())), msg.getErrorMsg());
                            slaveErrorMsgSheetMap.put(this.getStringValue(m.get(masterForeignColumn.getName())), msg.getSlaveErrorMsg());
                        }
                    });
                    Map<Integer, List<ImportTableConfig>> slaveSheetMap = slaveTableConfig.stream().collect(Collectors.groupingBy(ImportTableConfig::getSheetNo));
                    slaveSheetMap.entrySet().forEach(sMap -> {
                        Integer sheetNo = (Integer)sMap.getKey();
                        List tempSlaveList = (List)sMap.getValue();
                        ArrayList<ImportTableConfig.ImportColumnConfig> tempColumnList = new ArrayList<ImportTableConfig.ImportColumnConfig>();
                        tempSlaveList.stream().forEach(temp -> tempColumnList.addAll(temp.getColumns()));
                        int max = 0;
                        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                        ImportTableConfig tempSlave = (ImportTableConfig)tempSlaveList.get(0);
                        for (ImportTableConfig tableConfig : tempSlaveList) {
                            ImportTableConfig.ImportColumnConfig childForeignColumn1 = tableConfig.getColumns().stream().filter(a -> a.isForeign()).findFirst().orElse(null);
                            List tempDataList = ((List)slaveDataMaps.get(tableConfig.getTableName())).stream().filter(m -> masterCodes.containsKey(this.getStringValue(m.get(childForeignColumn1.getName())))).map(m -> {
                                Map slaveErrorMsg = (Map)slaveErrorMsgSheetMap.get(this.getStringValue(m.get(childForeignColumn1.getName())));
                                String errorMsg = "";
                                if (slaveErrorMsg != null) {
                                    String msg;
                                    Map slaveRowErrorMsg = (Map)slaveErrorMsg.get(sheetNo);
                                    if (slaveRowErrorMsg != null && StringUtils.isNotBlank((CharSequence)(msg = (String)slaveRowErrorMsg.get(m.get("excelRowNum"))))) {
                                        errorMsg = msg;
                                    }
                                } else {
                                    errorMsg = (String)masterCodes.get(this.getStringValue(m.get(childForeignColumn1.getName())));
                                }
                                m.put("\u5f02\u5e38\u4fe1\u606f", errorMsg);
                                return m;
                            }).collect(Collectors.toList());
                            if (tempDataList.size() <= max) continue;
                            max = tempDataList.size();
                            mapList = tempDataList;
                            tempSlave = tableConfig;
                        }
                        if (((Integer)sMap.getKey()).equals(masterTableConfig.getSheetNo())) {
                            tempColumnList.addAll(masterTableConfig.getColumns());
                        }
                        List<ImportTableConfig.ImportColumnConfig> columnList = tempColumnList.stream().filter(ExcelExportUtils.distinctByKey(b -> b.getName())).collect(Collectors.toList());
                        int beginRow = tempSlave.getTitleRow() + tempSlave.getStartRow() + 1;
                        ExcelExportUtils.appendDataAtContent(workbook, mapList, columnList, tempSlave, beginRow, true);
                    });
                    if (!slaveSheetMap.containsKey(masterTableConfig.getSheetNo())) {
                        this.masterSheetAppendErrorMsg(masterTableConfig, masterDataResult, failMsgList, workbook);
                    }
                } else {
                    this.masterSheetAppendErrorMsg(masterTableConfig, masterDataResult, failMsgList, workbook);
                }
                String username = masterTableConfig.getUserInfo() != null ? masterTableConfig.getUserInfo().getString("userName") : "";
                string = this.uploadWbFile(workbook, username, storageFileHelper);
                if (Collections.singletonList(workbook).get(0) == null) break block9;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
                throw throwable;
            }
            workbook.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleImageUpload(InputStream in, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfigList, StorageFileHelper storageFileHelper, List<Map<String, Object>> masterDataList, Map<String, List<Map<String, Object>>> slaveDataMaps) {
        if (CollectionUtils.isEmpty(slaveTableConfigList)) {
            slaveTableConfigList = new ArrayList<ImportTableConfig>();
        }
        List<ImportTableConfig.ImportColumnConfig> masterColumnList = masterTableConfig.getColumns().stream().filter(item -> ImportColumnDataType.IMAGE.equals((Object)item.getDataType())).collect(Collectors.toList());
        boolean imageColumnExist = CollectionUtils.isNotEmpty(masterColumnList);
        for (ImportTableConfig config : slaveTableConfigList) {
            if (imageColumnExist) break;
            long count = config.getColumns().stream().filter(item -> ImportColumnDataType.IMAGE.equals((Object)item.getDataType())).count();
            imageColumnExist = count > 0L;
        }
        if (!imageColumnExist) {
            return;
        }
        Workbook book = null;
        try {
            book = WorkbookFactory.create((InputStream)in);
            boolean isXSSFWorkbook = !(book instanceof HSSFWorkbook);
            Integer sheetNo = null;
            Integer titleRowNo = null;
            if (CollectionUtils.isNotEmpty(masterColumnList)) {
                sheetNo = masterTableConfig.getSheetNo();
                titleRowNo = masterTableConfig.getTitleRow();
                this.uploadImageFileByTable(storageFileHelper, masterDataList, masterColumnList, book, isXSSFWorkbook, sheetNo, titleRowNo);
            }
            if (CollectionUtils.isNotEmpty(slaveTableConfigList)) {
                for (ImportTableConfig config : slaveTableConfigList) {
                    List<ImportTableConfig.ImportColumnConfig> imageColumnList = config.getColumns().stream().filter(item -> ImportColumnDataType.IMAGE.equals((Object)item.getDataType())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(imageColumnList)) continue;
                    sheetNo = config.getSheetNo();
                    titleRowNo = config.getTitleRow();
                    this.uploadImageFileByTable(storageFileHelper, slaveDataMaps.get(config.getTableName()), imageColumnList, book, isXSSFWorkbook, sheetNo, titleRowNo);
                }
            }
        }
        catch (Exception e) {
            log.error("###ExportImportEngine.ExcelFileImportHandler.handleImageUpload.Error.tableName: {} ", (Object)masterTableConfig.getTableName(), (Object)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)book);
        }
    }

    private void uploadImageFileByTable(StorageFileHelper storageFileHelper, List<Map<String, Object>> dataList, List<ImportTableConfig.ImportColumnConfig> columnList, Workbook book, boolean isXSSFWorkbook, Integer sheetNo, Integer titleRowNo) {
        Map pictures = isXSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)((XSSFSheet)book.getSheetAt(sheetNo.intValue())), (XSSFWorkbook)((XSSFWorkbook)book)) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)((HSSFSheet)book.getSheetAt(sheetNo.intValue())), (HSSFWorkbook)((HSSFWorkbook)book));
        if (null == pictures || pictures.isEmpty()) {
            return;
        }
        Sheet sheet = book.getSheetAt(sheetNo.intValue());
        if (null == sheet) {
            return;
        }
        Map<Integer, String> titleMap = ExcelFileImportHandler.getTitleMap(sheet, titleRowNo, sheetNo);
        Set<Integer> keys = titleMap.keySet();
        HashMap<String, Integer> imageTitleMap = new HashMap<String, Integer>();
        for (Integer cn : keys) {
            String titleString = titleMap.get(cn);
            long exist = columnList.stream().filter(item -> titleString.equals(item.getName())).count();
            if (exist <= 0L) continue;
            imageTitleMap.put(titleString, cn);
        }
        columnList.forEach(column -> {
            for (Map columnData : dataList) {
                ByteArrayInputStream input;
                block5: {
                    Integer currentRowNum = columnData.getOrDefault("excelRowNum", null);
                    if (null == currentRowNum) continue;
                    Integer n = currentRowNum;
                    currentRowNum = currentRowNum - 1;
                    String picId = currentRowNum + "_" + imageTitleMap.get(column.getName());
                    PictureData image = (PictureData)pictures.get(picId);
                    if (null == image) continue;
                    byte[] data = image.getData();
                    input = null;
                    try {
                        input = new ByteArrayInputStream(data);
                        String filePath = FileUploadUtils.uploadFile("excel-image", input, storageFileHelper, "excel-import-image", "", ".png", "");
                        if (!StringUtils.isNotBlank((CharSequence)filePath)) break block5;
                        columnData.put(column.getName(), filePath);
                    }
                    catch (Exception e) {
                        try {
                            log.error("###ExportImportEngine.ExcelFileImportHandler.handleImageUpload.Error. sheetNo: {}, RowNum: {}, \u5217\u6807\u9898: {}", new Object[]{sheetNo, currentRowNum, column.getName(), e});
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(input);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)input);
                        continue;
                    }
                }
                IOUtils.closeQuietly((Closeable)input);
            }
        });
    }

    public static Map<Integer, String> getTitleMap(Sheet sheet, Integer rowNum, Integer sheetNo) {
        HashMap titleMap = Maps.newHashMap();
        Row row = sheet.getRow(rowNum.intValue());
        if (null == row) {
            throw new IllegalArgumentException(String.format("\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u7b2c\u3010%s\u3011sheet\u7684\u6807\u9898\u884c\u4e0d\u5b58\u5728", sheetNo));
        }
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            String value = ExcelFileImportHandler.getKeyValue(cell);
            value = value.replace("\n", "");
            int i = cell.getColumnIndex();
            titleMap.put(i, value);
        }
        return titleMap;
    }

    private String uploadWbFile(Workbook workbook, String username, StorageFileHelper storageFileHelper) {
        return FileUploadUtils.uploadFile("export", workbook, storageFileHelper, "import-fail-mgs", "", ExcelFileType.EXCEL2007.toFileExt(), username);
    }

    private int getExcelLastRowNo(ImportTableConfig tableConfig, ExcelImportResult<Map<String, Object>> result) {
        return 1 + tableConfig.getTitleRow() + tableConfig.getStartRow() + result.getList().size() + result.getFailList().size();
    }

    private boolean checkExcelLineAllBlank(Map<String, Object> dataMap, ImportTableConfig tableConfig) {
        for (Map.Entry<String, Object> data : dataMap.entrySet()) {
            if ("excelRowNum".equals(data.getKey()) || "excelErrorMsg".equals(data.getKey()) || data.getValue() == null) continue;
            boolean defaultEnum = false;
            for (ImportTableConfig.ImportColumnConfig column : tableConfig.getColumns()) {
                if (!CollectionUtils.isNotEmpty(column.getEnumList()) || !column.getName().equals(data.getKey())) continue;
                for (ImportTableConfig.ExcelColumnEnum columnEnum : column.getEnumList()) {
                    if (!columnEnum.isDefaultValue() || !data.getValue().equals(columnEnum.getValue())) continue;
                    defaultEnum = true;
                }
            }
            if (defaultEnum) continue;
            return false;
        }
        return true;
    }

    private boolean checkExcelLineSingleTableAllBlank(Map<String, Object> dataMap, ImportTableConfig tableConfig) {
        for (Map.Entry<String, Object> data : dataMap.entrySet()) {
            if ("excelRowNum".equals(data.getKey()) || "excelErrorMsg".equals(data.getKey())) continue;
            List<String> columnNames = Arrays.asList(tableConfig.getColumnNames());
            if (data.getValue() == null || !columnNames.contains(data.getKey())) continue;
            boolean defaultEnum = false;
            for (ImportTableConfig.ImportColumnConfig column : tableConfig.getColumns()) {
                if (!CollectionUtils.isNotEmpty(column.getEnumList()) || !column.getName().equals(data.getKey())) continue;
                for (ImportTableConfig.ExcelColumnEnum columnEnum : column.getEnumList()) {
                    if (!columnEnum.isDefaultValue() || !data.getValue().equals(columnEnum.getValue())) continue;
                    defaultEnum = true;
                }
            }
            if (defaultEnum) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkTitle(InputStream inputStream, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig) {
        try {
            FileMagic fm = FileMagic.valueOf((InputStream)inputStream);
            switch (fm) {
                case OLE2: 
                case OOXML: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u4e3a:%s, \u975eexcel\u683c\u5f0f\uff0c\u8bf7\u8f6c\u5316\u6210xlsx\u6216\u8005xls\u540e\u8fdb\u884c\u4e0a\u4f20", fm.name()));
                }
            }
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            ArrayList allConfigList = Lists.newArrayList();
            allConfigList.add(masterTableConfig);
            if (CollectionUtils.isNotEmpty(slaveTableConfig)) {
                allConfigList.addAll(slaveTableConfig);
            }
            this.checkSheetName(workbook, allConfigList);
            for (ImportTableConfig config : allConfigList) {
                ExcelFileImportHandler.checkExcelTitleByConfig(config, workbook);
            }
        }
        catch (IOException e) {
            log.error("ImportExcelConfigUtil.checkExcelTile.Error.excel\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new IllegalArgumentException("excel\u6587\u4ef6\u5f02\u5e38");
        }
    }

    private void checkSheetName(Workbook workbook, List<ImportTableConfig> allConfigList) {
        boolean useSheetNo = true;
        for (ImportTableConfig config : allConfigList) {
            if (config.isUseSheetNo()) continue;
            if (StringUtils.isBlank((CharSequence)config.getSheetName())) {
                throw new IllegalArgumentException("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, sheet\u540d\u79f0\u672a\u914d\u7f6e");
            }
            useSheetNo = false;
            break;
        }
        if (!useSheetNo) {
            HashMap sheetNameMap = Maps.newHashMap();
            int i = 0;
            while (true) {
                try {
                    String sheetName = workbook.getSheetName(i);
                    sheetNameMap.put(sheetName, i);
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            for (ImportTableConfig config : allConfigList) {
                if (config.isUseSheetNo()) continue;
                Integer sheetNo = (Integer)sheetNameMap.get(config.getSheetName());
                if (null == sheetNo) {
                    throw new IllegalArgumentException("\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, " + String.format("\u540d\u79f0\u4e3a: \u3010%s\u3011\u7684sheet\u9875\u4e0d\u5b58\u5728", config.getSheetName()));
                }
                config.setSheetNo(sheetNo);
            }
        }
    }

    private static void checkExcelTitleByConfig(ImportTableConfig config, Workbook workbook) {
        int totalSheetNumber = workbook.getNumberOfSheets();
        if (config.getSheetNo() >= totalSheetNumber) {
            String errorMessage = "\u5f53\u524dExcel\u7684Sheet\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\uff01";
            throw new RuntimeException(errorMessage);
        }
        Sheet importSheet = workbook.getSheetAt(config.getSheetNo());
        Map<Integer, String> titleMap = ExcelFileImportHandler.getTitleMap(importSheet, config.getTitleRow(), config.getSheetNo());
        String format = "\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, \u8868\u540d\u3010%s\u3011\u7684\u914d\u7f6e, \u7b2c\u3010%s\u3011sheet\u4e2d\u4e0d\u5b58\u5728\u6807\u9898\u4e3a\u3010%s\u3011\u7684\u5355\u5143\u5217\uff0c\u8bf7\u786e\u8ba4";
        config.getColumns().forEach(column -> {
            if (column.getIsNotNull().booleanValue() && !titleMap.containsValue(column.getName())) {
                throw new IllegalArgumentException(String.format(format, config.getTableName(), config.getSheetNo(), column.getName()));
            }
        });
    }

    private static String getKeyValue(Cell cell) {
        String obj = PoiCellUtil.getCellValue((Cell)cell);
        return obj == null ? null : obj.toString().trim();
    }

    private String getStringValue(Object value) {
        if (null == value) {
            return "";
        }
        if (value instanceof Integer) {
            return String.valueOf(value);
        }
        return value.toString();
    }

    private void masterSheetAppendErrorMsg(ImportTableConfig masterTableConfig, ImportTransferResult masterConvertResult, List<ImportErrorMsgDto> failResultMsgList, Workbook workbook) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        masterConvertResult.getList().stream().forEach(m -> {
            Integer num = (Integer)m.get("excelRowNum");
            for (ImportErrorMsgDto msg : failResultMsgList) {
                if (!msg.getRowNo().equals(num)) continue;
                m.put("\u5f02\u5e38\u4fe1\u606f", msg.getErrorMsg());
                mapList.add((Map<String, Object>)m);
            }
        });
        int beginRow = masterTableConfig.getTitleRow() + masterTableConfig.getStartRow() + 1;
        ExcelExportUtils.appendDataAtContent(workbook, mapList, masterTableConfig.getColumns(), masterTableConfig, beginRow, true);
    }
}

