/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.handler;

import com.xinqiyi.framework.excel.handler.AbstractFileImportHandler;
import com.xinqiyi.framework.excel.handler.CsvFileImportHandler;
import com.xinqiyi.framework.excel.handler.ExcelFileImportHandler;
import com.xinqiyi.framework.excel.model.FileType;
import org.apache.commons.lang3.StringUtils;

public class FileImportHandlerFactory {
    public static AbstractFileImportHandler getFileImportHandler(FileType fileType) {
        if (null == fileType) {
            fileType = FileType.EXCEL;
        }
        switch (fileType) {
            case EXCEL: {
                return new ExcelFileImportHandler();
            }
            case CSV: {
                return new CsvFileImportHandler();
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6587\u4ef6\u683c\u5f0f");
    }

    public static FileType getFileTypeByFileName(String originFileName) {
        if (StringUtils.isBlank((CharSequence)originFileName)) {
            return FileType.EXCEL;
        }
        if (originFileName.endsWith(".csv")) {
            return FileType.CSV;
        }
        return FileType.EXCEL;
    }
}

