/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.util;

import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.excel.model.ImportColumnDataType;
import com.xinqiyi.framework.excel.model.ImportErrorMsgDto;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;

public class ExcelExportUtils {
    private static final String DEFAULT_EXCEL_FONT_NAME = "simsun";
    private static final short DEFAULT_EXCEL_FONT_SIZE = 10;
    public static final String EXCEL_HEAD_DATA_TYPE_NUMBER = "NUMBER";
    public static final String EXCEL_HEAD_DATA_TYPE_STRING = "STRING";
    public static final String EXCEL_ERROR_MSG_TITLE = "\u5f02\u5e38\u4fe1\u606f";
    public static final String EXCEL_ERROR_MSG_FILE_PREFIX = "import-fail-mgs";
    public static final String EXCEL_EXPORT_DIRECTORY_PREFIX = "export";
    public static final String IMAGE_POSITION_FORMAT = "%s_%s";

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentMap seen = Maps.newConcurrentMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static Workbook appendDataAtContent(Workbook wb, List<Map<String, Object>> dataList, List<ImportTableConfig.ImportColumnConfig> columnNameMapping, ImportTableConfig importTableConfig, int beginRow, boolean errorLine) {
        CellStyle strStyle = ExcelExportUtils.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_STRING, null);
        CellStyle strRedStyle = ExcelExportUtils.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_STRING, IndexedColors.RED);
        Sheet sheet = wb.getSheetAt(importTableConfig.getSheetNo());
        for (int i = beginRow; i <= sheet.getLastRowNum(); ++i) {
            Row removingRow = sheet.getRow(i);
            if (null == removingRow) continue;
            sheet.removeRow(removingRow);
        }
        Row titleRow = sheet.getRow(importTableConfig.getTitleRow());
        short lastCellNum = titleRow.getLastCellNum();
        if (errorLine) {
            Cell cell = titleRow.createCell((int)lastCellNum);
            String columnValue = ExcelExportUtils.formatDefaultDataValue(EXCEL_ERROR_MSG_TITLE);
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(strRedStyle);
            cell.setCellValue(columnValue);
            columnNameMapping.add(new ImportTableConfig.ImportColumnConfig(EXCEL_ERROR_MSG_TITLE, EXCEL_ERROR_MSG_TITLE));
        }
        HashMap headerMappingMap = Maps.newHashMap();
        for (ImportTableConfig.ImportColumnConfig columnConfig : columnNameMapping) {
            headerMappingMap.put(columnConfig.getName(), columnConfig.getName());
        }
        HashMap<String, String> imgPosMapping = new HashMap<String, String>();
        Map<String, Integer> titleColMap = ExcelExportUtils.getTitleColMap(columnNameMapping, importTableConfig, sheet);
        dataList.forEach(map -> columnNameMapping.forEach(columnConfig -> {
            if (null != columnConfig.getEnumMap()) {
                Object o = map.get(columnConfig.getName());
                map.put(columnConfig.getName(), columnConfig.transfer2EnumKey(o));
            }
            if (ImportColumnDataType.IMAGE.equals((Object)columnConfig.getDataType())) {
                Integer col;
                map.put(columnConfig.getName(), "");
                Integer row = (Integer)map.get("excelRowNum");
                if (null != row && (col = (Integer)titleColMap.get(columnConfig.getName())) != null) {
                    imgPosMapping.put(String.format(IMAGE_POSITION_FORMAT, row - 1, col), "");
                }
            }
        }));
        for (int i = 0; i < dataList.size(); ++i) {
            int rowIndex = i + beginRow;
            Row newExcelRow = sheet.createRow(rowIndex);
            newExcelRow.setHeight((short)(newExcelRow.getHeight() * 2));
            for (int j = 0; j < titleRow.getLastCellNum(); ++j) {
                Object value;
                String header;
                String mapping;
                if (titleRow.getCell(j) == null || !StringUtils.isNotBlank((CharSequence)(mapping = (String)headerMappingMap.get(header = titleRow.getCell(j).toString())))) continue;
                Map<String, Object> dataMap = dataList.get(i);
                Integer oldRowNum = (Integer)dataMap.get("excelRowNum");
                if (null != oldRowNum && imgPosMapping.containsKey(String.format(IMAGE_POSITION_FORMAT, oldRowNum - 1, j))) {
                    imgPosMapping.put(String.format(IMAGE_POSITION_FORMAT, oldRowNum - 1, j), String.format(IMAGE_POSITION_FORMAT, rowIndex, j));
                }
                if (null == (value = dataMap.get(mapping))) continue;
                Cell cell = newExcelRow.createCell(j);
                String columnValue = ExcelExportUtils.formatDefaultDataValue(value);
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(strStyle);
                if (mapping.equals(EXCEL_ERROR_MSG_TITLE)) {
                    cell.setCellStyle(strRedStyle);
                }
                cell.setCellValue(columnValue);
            }
        }
        List imageColumnList = columnNameMapping.stream().filter(item -> ImportColumnDataType.IMAGE.equals((Object)item.getDataType())).collect(Collectors.toList());
        boolean imageColumnExist = CollectionUtils.isNotEmpty(imageColumnList);
        if (imageColumnExist) {
            ExcelExportUtils.changeAndRemoveImage(wb, sheet, imgPosMapping);
        }
        return wb;
    }

    private static Map<String, Integer> getTitleColMap(List<ImportTableConfig.ImportColumnConfig> columnNameMapping, ImportTableConfig importTableConfig, Sheet sheet) {
        Map<Integer, String> titleMap = ExcelExportUtils.getTitleMap(sheet, importTableConfig.getTitleRow());
        Set<Integer> keys = titleMap.keySet();
        HashMap<String, Integer> imageTitleMap = new HashMap<String, Integer>();
        for (Integer cn : keys) {
            String titleString = titleMap.get(cn);
            long exist = columnNameMapping.stream().filter(item -> titleString.equals(item.getName())).count();
            if (exist <= 0L) continue;
            imageTitleMap.put(titleString, cn);
        }
        return imageTitleMap;
    }

    public static Map<Integer, String> getTitleMap(Sheet sheet, Integer rowNum) {
        HashMap titleMap = Maps.newHashMap();
        Row row = sheet.getRow(rowNum.intValue());
        if (null == row) {
            return new HashMap<Integer, String>();
        }
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            String value = ExcelExportUtils.getKeyValue(cell);
            value = value.replace("\n", "");
            int i = cell.getColumnIndex();
            titleMap.put(i, value);
        }
        return titleMap;
    }

    private static String getKeyValue(Cell cell) {
        String obj = PoiCellUtil.getCellValue((Cell)cell);
        return obj == null ? null : obj.toString().trim();
    }

    private static void changeAndRemoveImage(Workbook wb, Sheet sheet, Map<String, String> imgPosMapping) {
        block6: {
            block5: {
                boolean isXSSFWorkbook;
                boolean bl = isXSSFWorkbook = !(wb instanceof HSSFWorkbook);
                if (!isXSSFWorkbook) break block5;
                Drawing drawing = sheet.getDrawingPatriarch();
                if (!(drawing instanceof XSSFDrawing)) break block6;
                XSSFDrawing xssfDrawing = (XSSFDrawing)drawing;
                for (XSSFShape shape : xssfDrawing.getShapes()) {
                    if (!(shape instanceof XSSFPicture)) continue;
                    XSSFPicture picture = (XSSFPicture)shape;
                    XSSFClientAnchor anchor = picture.getClientAnchor();
                    String picIndex = String.format(IMAGE_POSITION_FORMAT, anchor.getFrom().getRow(), anchor.getFrom().getCol());
                    String picPosition = imgPosMapping.get(picIndex);
                    if (StringUtils.isNotBlank((CharSequence)picPosition)) {
                        String[] pos = picPosition.split("_");
                        Integer row = Integer.valueOf(pos[0]);
                        Integer col = Integer.valueOf(pos[1]);
                        anchor.setCol1(col.intValue());
                        anchor.setRow1(row.intValue());
                        anchor.setCol2(col.intValue());
                        anchor.setRow2(row.intValue());
                        continue;
                    }
                    anchor.setCol1(0);
                    anchor.setRow1(0);
                    anchor.setCol2(0);
                    anchor.setRow2(0);
                    picture.resize(0.0);
                }
                break block6;
            }
            List pictures = ((HSSFWorkbook)wb).getAllPictures();
            if (!pictures.isEmpty()) {
                for (HSSFShape shape : ((HSSFSheet)sheet).getDrawingPatriarch().getChildren()) {
                    HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                    if (!(shape instanceof HSSFPicture)) continue;
                    HSSFPicture pic = (HSSFPicture)shape;
                    String picIndex = String.format(IMAGE_POSITION_FORMAT, anchor.getRow1(), anchor.getCol1());
                    String picPosition = imgPosMapping.get(picIndex);
                    if (StringUtils.isNotBlank((CharSequence)picPosition)) {
                        String[] pos = picPosition.split("_");
                        Integer row = Integer.valueOf(pos[0]);
                        Integer col = Integer.valueOf(pos[1]);
                        anchor.setCol1(col.intValue());
                        anchor.setRow1(row.intValue());
                        anchor.setCol2(col.intValue());
                        anchor.setRow2(row.intValue());
                        continue;
                    }
                    anchor.setCol1(0);
                    anchor.setRow1(0);
                    anchor.setCol2(0);
                    anchor.setRow2(0);
                    pic.resize(0.0);
                }
            }
        }
    }

    private static String formatDefaultDataValue(Object dataValue) {
        if (dataValue instanceof Date) {
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format((Date)dataValue);
        }
        if (dataValue instanceof LocalDateTime) {
            return LocalDateTimeUtil.format((LocalDateTime)((LocalDateTime)dataValue), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (dataValue instanceof BigDecimal) {
            return ((BigDecimal)dataValue).setScale(2, RoundingMode.HALF_UP).toString();
        }
        return dataValue == null ? "" : dataValue.toString();
    }

    private static CellStyle buildCellStyle(Workbook wb, boolean isBold, boolean isNotNull, String type, IndexedColors colors) {
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName(DEFAULT_EXCEL_FONT_NAME);
        font.setColor(IndexedColors.BLACK.getIndex());
        if (null != colors) {
            font.setColor(colors.getIndex());
        }
        if (isBold) {
            font.setBold(true);
        }
        CellStyle style = wb.createCellStyle();
        style.setFont(font);
        DataFormat format = wb.createDataFormat();
        if (StringUtils.equalsIgnoreCase((CharSequence)EXCEL_HEAD_DATA_TYPE_STRING, (CharSequence)type)) {
            style.setDataFormat(format.getFormat("text"));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)EXCEL_HEAD_DATA_TYPE_NUMBER, (CharSequence)type)) {
            style.setDataFormat(format.getFormat("General"));
        }
        return style;
    }

    public static void appendErrorMsg(Workbook wb, ImportTableConfig config, Map<Integer, ImportErrorMsgDto> errorMsgMap) {
        int begin;
        CellStyle strRedStyle = ExcelExportUtils.buildCellStyle(wb, false, false, EXCEL_HEAD_DATA_TYPE_STRING, IndexedColors.RED);
        Sheet sheet = wb.getSheetAt(config.getSheetNo());
        Row titleRow = sheet.getRow(config.getTitleRow());
        short lastCellNum = titleRow.getLastCellNum();
        Cell errorCell = titleRow.createCell((int)lastCellNum);
        String columnValue = ExcelExportUtils.formatDefaultDataValue(EXCEL_ERROR_MSG_TITLE);
        errorCell.setCellType(CellType.STRING);
        errorCell.setCellStyle(strRedStyle);
        errorCell.setCellValue(columnValue);
        for (int i = begin = config.getTitleRow() + config.getStartRow() + 1; i <= sheet.getLastRowNum(); ++i) {
            Row newExcelRow;
            ImportErrorMsgDto errorMsgDto = errorMsgMap.get(i + 1);
            if (null == errorMsgDto || null == (newExcelRow = sheet.getRow(i))) continue;
            Cell cell = newExcelRow.createCell((int)lastCellNum);
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(strRedStyle);
            cell.setCellValue(errorMsgDto.getErrorMsg());
        }
    }
}

