/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.util;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.excel.model.TaskInfo;
import com.xinqiyi.framework.redis.RedisHelper;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ExcelRedisHelper {
    private static final long DEFAULT_REDIS_TIME_OUT = 86400L;
    private static final String TASK_KEY_PREFIX = "xinqiyi:sys:excel:task:";

    private static String buildTaskKey(Long taskId) {
        return TASK_KEY_PREFIX + taskId.toString();
    }

    public static void saveTask(Long taskId, TaskInfo taskInfo) {
        String taskKey = ExcelRedisHelper.buildTaskKey(taskId);
        RedisHelper.getRedisTemplate().opsForValue().set((Object)taskKey, (Object)JSON.toJSONString((Object)taskInfo), 86400L, TimeUnit.SECONDS);
    }

    public static TaskInfo selectTaskInfo(Long taskId) {
        String taskKey = ExcelRedisHelper.buildTaskKey(taskId);
        if (!RedisHelper.getRedisTemplate().hasKey((Object)taskKey).booleanValue()) {
            return null;
        }
        String taskValue = (String)RedisHelper.getRedisTemplate().opsForValue().get((Object)taskKey);
        if (StringUtils.isEmpty((CharSequence)taskValue)) {
            return null;
        }
        return (TaskInfo)JSON.parseObject((String)taskValue, TaskInfo.class);
    }

    public static void removeTaskInfo(Long taskId) {
        String taskKey = ExcelRedisHelper.buildTaskKey(taskId);
        RedisHelper.getRedisTemplate().delete((Object)taskKey);
    }
}

