/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.util;

import cn.hutool.core.date.DateUtil;
import com.xinqiyi.framework.file.StorageFileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;

public class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String directoryPrefix, InputStream inputStream, StorageFileHelper storageFileHelper, String fileNamePrefix, String fileName, String fileExt, String username) {
        String string;
        block6: {
            StringBuilder uploadSaveFileName = FileUploadUtils.getUploadSaveFileName(fileNamePrefix, fileName);
            String fullFileName = FileUploadUtils.buildLocalTempExcelFile(fileName, fileExt);
            File dest = new File(fullFileName);
            FileOutputStream out = new FileOutputStream(dest);
            try {
                StreamUtils.copy((InputStream)inputStream, (OutputStream)out);
                String uploadSavePath = FileUploadUtils.getFileDirectoryPrefix(directoryPrefix);
                String afterUploadFileName = storageFileHelper.getDefaultStorageFileOperate().uploadFile(uploadSavePath, uploadSaveFileName.toString(), fileExt, fullFileName, username);
                dest.delete();
                string = afterUploadFileName;
                if (Collections.singletonList(out).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(out).get(0) != null) {
                        ((OutputStream)out).close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    return null;
                }
            }
            ((OutputStream)out).close();
        }
        return string;
    }

    public static StringBuilder getUploadSaveFileName(String fileNamePrefix, String fileName) {
        StringBuilder uploadSaveFileName = new StringBuilder();
        uploadSaveFileName.append(fileNamePrefix);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            if (uploadSaveFileName.length() > 0) {
                uploadSaveFileName.append("-");
            }
            uploadSaveFileName.append(fileName);
        }
        return uploadSaveFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String directoryPrefix, Workbook workbook, StorageFileHelper storageFileHelper, String fileNamePrefix, String fileName, String fileExt, String username) {
        String string;
        block6: {
            StringBuilder uploadSaveFileName = FileUploadUtils.getUploadSaveFileName(fileNamePrefix, fileName);
            String fullFileName = FileUploadUtils.buildLocalTempExcelFile(fileName, fileExt);
            File dest = new File(fullFileName);
            FileOutputStream out = new FileOutputStream(dest);
            try {
                workbook.write((OutputStream)out);
                String uploadSavePath = FileUploadUtils.getFileDirectoryPrefix(directoryPrefix);
                String afterUploadFileName = storageFileHelper.getDefaultStorageFileOperate().uploadFile(uploadSavePath, uploadSaveFileName.toString(), fileExt, fullFileName, username);
                dest.delete();
                string = afterUploadFileName;
                if (Collections.singletonList(out).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(out).get(0) != null) {
                        ((OutputStream)out).close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    return null;
                }
            }
            ((OutputStream)out).close();
        }
        return string;
    }

    public static String getFileDirectoryPrefix(String prefix) {
        return prefix + "/" + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
    }

    public static String buildLocalTempExcelFile(String fileName, String fileExt) throws Exception {
        boolean mkResult;
        Object tempPath = ResourceUtils.getURL((String)"/home/admin/tmp/").getPath();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String currentDate = FastDateFormat.getInstance((String)"yyyyMMdd").format(new Date());
        File savePathInfo = new File((String)(tempPath = (String)tempPath + File.separator + currentDate + File.separator + "export" + File.separator + uuid + File.separator));
        if (!savePathInfo.isDirectory() && !(mkResult = savePathInfo.mkdirs())) {
            throw new Exception("ExportExcelEngine.buildLocalTempExcelFile MkDir Failed");
        }
        return (String)tempPath + fileName + fileExt;
    }
}

