/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.excel.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.excel.handler.FileImportHandlerFactory;
import com.xinqiyi.framework.excel.model.ExcelVerifyResultDTO;
import com.xinqiyi.framework.excel.model.FileType;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import com.xinqiyi.framework.excel.model.RealTimeDictConfig;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ImportExcelConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelConfigUtil.class);
    public static final String SLAVE_TABLE = "slaveTable";
    public static final String MASTER_TABLE = "masterTable";
    public static final String REAL_TIME_DICT = "realTimeDict";
    public static final String ERROR_MSG_PREFIX = "\u5bfc\u5165\u6a21\u677f\u4e0e\u9009\u62e9\u7684\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d, ";
    public static final String ERROR_CONFIG_MSG_PREFIX = "\u6a21\u677f\u914d\u7f6e\u9519\u8bef, ";

    public static ExcelVerifyResultDTO checkExcelTemplateConfig(String configStr, InputStream inputStream) {
        return ImportExcelConfigUtil.checkExcelTemplateConfig(configStr, inputStream, FileType.EXCEL);
    }

    public static ExcelVerifyResultDTO checkExcelTemplateConfig(String configStr, InputStream inputStream, FileType fileType) {
        try {
            if (!ImportExcelConfigUtil.isJsonObject(configStr)) {
                return ExcelVerifyResultDTO.fail("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u6a21\u677f\u914d\u7f6e\u975ejson\u683c\u5f0f");
            }
            JSONObject jsonObject = JSON.parseObject((String)configStr);
            String masterTable = jsonObject.getString(MASTER_TABLE);
            if (StringUtils.isBlank((CharSequence)masterTable)) {
                return ExcelVerifyResultDTO.fail("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u4e3b\u8868\u672a\u914d\u7f6e");
            }
            ImportTableConfig masterTableConfig = (ImportTableConfig)JSON.parseObject((String)masterTable, ImportTableConfig.class);
            String slaveTable = jsonObject.getString(SLAVE_TABLE);
            if (StringUtils.isNotBlank((CharSequence)slaveTable) && !ImportExcelConfigUtil.isJsonArray(slaveTable)) {
                return ExcelVerifyResultDTO.fail("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u5b50\u8868\u6a21\u677f\u914d\u7f6e\u975ejson\u683c\u5f0f");
            }
            String realTimeDict = jsonObject.getString(REAL_TIME_DICT);
            if (StringUtils.isNotBlank((CharSequence)realTimeDict) && !ImportExcelConfigUtil.isJsonArray(realTimeDict)) {
                return ExcelVerifyResultDTO.fail("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u6570\u636e\u5b57\u5178\u914d\u7f6e\u975ejson\u683c\u5f0f");
            }
            List slaveTableConfig = StringUtils.isNotEmpty((CharSequence)slaveTable) ? JSON.parseArray((String)slaveTable, ImportTableConfig.class) : null;
            List realTimeDictConfigList = StringUtils.isNotBlank((CharSequence)realTimeDict) ? JSON.parseArray((String)realTimeDict, RealTimeDictConfig.class) : null;
            ImportExcelConfigUtil.checkTemplateForeignKey(masterTableConfig, slaveTableConfig);
            ImportExcelConfigUtil.checkRealDictConfig(realTimeDictConfigList);
            if (null != inputStream) {
                FileImportHandlerFactory.getFileImportHandler(fileType).checkTitle(inputStream, masterTableConfig, slaveTableConfig);
            }
        }
        catch (Exception e) {
            return ExcelVerifyResultDTO.fail(e.getMessage());
        }
        return ExcelVerifyResultDTO.success("");
    }

    public static void checkExcelTile(InputStream inputStream, ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig) {
        FileImportHandlerFactory.getFileImportHandler(masterTableConfig.getFileType()).checkTitle(inputStream, masterTableConfig, slaveTableConfig);
    }

    public static void checkTemplateForeignKey(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig) {
        if (CollectionUtils.isEmpty(slaveTableConfig)) {
            return;
        }
        ImportTableConfig.ImportColumnConfig masterForeignColumn = masterTableConfig.getColumns().stream().filter(a -> a.isForeign()).findFirst().orElse(null);
        Assert.notNull((Object)masterForeignColumn, (String)String.format("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u4e3b\u8868:%s, \u552f\u4e00\u952e\u672a\u914d\u7f6e", masterTableConfig.getTableName()));
        slaveTableConfig.forEach(importTableConfig -> {
            Long count = importTableConfig.getColumns().stream().filter(a -> a.isForeign()).count();
            if (count != 1L) {
                throw new IllegalArgumentException(String.format("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u5b50\u8868:%s, \u5173\u8054\u4e3b\u8868\u552f\u4e00\u952e\u672a\u914d\u7f6e", importTableConfig.getTableName()));
            }
        });
    }

    public static void checkRealDictConfig(List<RealTimeDictConfig> realTimeDictConfigList) {
        if (CollectionUtils.isEmpty(realTimeDictConfigList)) {
            return;
        }
        realTimeDictConfigList.stream().forEach(dict -> {
            if (StringUtils.isBlank((CharSequence)dict.getSheetName())) {
                throw new IllegalArgumentException("\u6a21\u677f\u914d\u7f6e\u9519\u8bef, \u672a\u914d\u7f6e\u5b57\u5178sheetName");
            }
            if (CollUtil.isEmpty(dict.getDetailList())) {
                throw new IllegalArgumentException(ERROR_CONFIG_MSG_PREFIX + dict.getSheetName() + "\u672a\u914d\u7f6e\u5b57\u5178\u660e\u7ec6");
            }
            dict.getDetailList().stream().forEach(dictConfigDetail -> {
                if (StringUtils.isBlank((CharSequence)dictConfigDetail.getApplicationName())) {
                    throw new IllegalArgumentException(ERROR_CONFIG_MSG_PREFIX + dict.getSheetName() + "\u5b57\u5178\u660e\u7ec6\u672a\u914d\u7f6e\u5e94\u7528\u540d\u79f0");
                }
                if (StringUtils.isBlank((CharSequence)dictConfigDetail.getTableName())) {
                    throw new IllegalArgumentException(ERROR_CONFIG_MSG_PREFIX + dict.getSheetName() + "\u5b57\u5178\u660e\u7ec6\u672a\u914d\u7f6e\u8868\u540d");
                }
                if (StringUtils.isBlank((CharSequence)dictConfigDetail.getColumnNames())) {
                    throw new IllegalArgumentException(ERROR_CONFIG_MSG_PREFIX + dict.getSheetName() + "\u5b50\u5f39\u660e\u7ec6\u672a\u914d\u7f6e\u5b57\u6bb5");
                }
            });
        });
    }

    public static boolean isJsonObject(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        try {
            JSONObject.parseObject((String)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJsonArray(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        try {
            JSONObject.parseArray((String)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

