/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.i18n;

import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.i18n.I18nMessageInitial;
import com.xinqiyi.framework.i18n.config.I18nConfig;
import com.xinqiyi.framework.util.ApplicationContextHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class I18nMessage {
    private static final Logger log = LoggerFactory.getLogger(I18nMessage.class);

    private static Properties loadI18nProp(String currentLocale) {
        if (MapUtils.isNotEmpty(I18nMessageInitial.getLocalePropertiesList())) {
            Properties currentProperties = (Properties)MapUtils.getObject(I18nMessageInitial.getLocalePropertiesList(), (Object)currentLocale);
            if (currentProperties == null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)currentLocale, (CharSequence)"zh_CN")) {
                    return null;
                }
                return I18nMessage.loadI18nProp("zh_CN");
            }
            return currentProperties;
        }
        return null;
    }

    private static String getDefaultLocale() {
        I18nConfig i18nConfig = (I18nConfig)ApplicationContextHelper.getBean(I18nConfig.class);
        if (ObjectUtils.isNotEmpty((Object)i18nConfig)) {
            return i18nConfig.getDefaultLocale();
        }
        return "zh_CN";
    }

    private static String getCurrentLocale() {
        HttpServletRequest webRequest;
        String currentLocale;
        GateWayWebAuthService gateWayWebAuthService = (GateWayWebAuthService)ApplicationContextHelper.getBean(GateWayWebAuthService.class);
        if (ObjectUtils.isEmpty((Object)gateWayWebAuthService)) {
            return I18nMessage.getDefaultLocale();
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes && StringUtils.isNotEmpty((CharSequence)(currentLocale = (webRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getHeader("locale")))) {
            return currentLocale;
        }
        return I18nMessage.getDefaultLocale();
    }

    public static String getString(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String currentLocale = I18nMessage.getCurrentLocale();
        Properties currentProperties = I18nMessage.loadI18nProp(currentLocale);
        if (currentProperties == null) {
            return key;
        }
        String propertyValue = currentProperties.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            return key;
        }
        return propertyValue;
    }

    public static String getString(String key, Object ... args) {
        String propertyValue = I18nMessage.getString(key);
        try {
            String afterFormatValue = MessageFormat.format(propertyValue, args);
            if (log.isDebugEnabled()) {
                log.debug("I18nMessage.getString.propertyValue={};;AfterFormatValue={}", (Object)propertyValue, (Object)afterFormatValue);
            }
            return afterFormatValue;
        }
        catch (Exception ex) {
            log.error("getString.Exception", (Throwable)ex);
            return propertyValue;
        }
    }
}

