/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.i18n;

import com.xinqiyi.framework.i18n.config.I18nConfig;
import com.xinqiyi.framework.i18n.loader.HttpPropertiesLoader;
import com.xinqiyi.framework.util.ApplicationContextHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class I18nMessageInitial {
    private static final Logger log = LoggerFactory.getLogger(I18nMessageInitial.class);
    private static ConcurrentHashMap<String, Properties> LOCALE_PROPERTIES_LIST;

    public static ConcurrentHashMap<String, Properties> getLocalePropertiesList() {
        return LOCALE_PROPERTIES_LIST;
    }

    public static void initialLocalProperties() {
        Map<String, List<String>> messagePropertiesList;
        I18nConfig i18nConfig = (I18nConfig)ApplicationContextHelper.getBean(I18nConfig.class);
        if (ObjectUtils.isEmpty((Object)i18nConfig)) {
            throw new RuntimeException("I18nUtil.getI18nConfig.Null");
        }
        if (!i18nConfig.isEnabled()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Start.InitialLocalProperties");
        }
        if ((messagePropertiesList = i18nConfig.getMessagePropertiesList()) == null) {
            messagePropertiesList = new HashMap<String, List<String>>();
        }
        if (!messagePropertiesList.containsKey("zh_CN")) {
            messagePropertiesList.put("zh_CN", List.of("classpath:i18n/message_zh_CN.properties"));
        }
        LOCALE_PROPERTIES_LIST = new ConcurrentHashMap();
        for (String locale : messagePropertiesList.keySet()) {
            List<String> fileNameList = messagePropertiesList.get(locale);
            for (String fileName : fileNameList) {
                if (StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"classpath:")) {
                    ClassPathResource resource = new ClassPathResource(fileName = StringUtils.replaceIgnoreCase((String)fileName, (String)"classpath:", (String)""));
                    if (resource.exists()) {
                        EncodedResource encodedResource = new EncodedResource((Resource)resource, "UTF-8");
                        try {
                            Properties localProperties = PropertiesLoaderUtils.loadProperties((EncodedResource)encodedResource);
                            LOCALE_PROPERTIES_LIST.put(locale, localProperties);
                        }
                        catch (Exception ex) {
                            log.error("PropertiesLoaderUtils.loadProperties.Exception.File={}", (Object)fileName, (Object)ex);
                        }
                        continue;
                    }
                    log.warn("I18nMessageInitial.fileName={}.Not.Exists", (Object)fileName);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"http://") || StringUtils.startsWithIgnoreCase((CharSequence)fileName, (CharSequence)"https://")) {
                    try {
                        Properties loadProperties = HttpPropertiesLoader.loadPropertiesFromUrl(fileName);
                        if (loadProperties == null) continue;
                        LOCALE_PROPERTIES_LIST.put(locale, loadProperties);
                    }
                    catch (Exception ex) {
                        log.error("HttpPropertiesLoader.loadPropertiesFromUrl.Exception.File={}", (Object)fileName, (Object)ex);
                    }
                    continue;
                }
                log.error("I18nUtil.loadI18nProp.Unknown.File={}", (Object)fileName);
            }
        }
        if (log.isInfoEnabled()) {
            for (String locale : LOCALE_PROPERTIES_LIST.keySet()) {
                Properties localProperties = LOCALE_PROPERTIES_LIST.get(locale);
                int propSize = localProperties == null ? 0 : localProperties.size();
                log.info("Loaded.Success.Locale={};PropertiesSize={}", (Object)locale, (Object)propSize);
            }
        }
    }
}

