/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.i18n.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPropertiesLoader {
    private static final Logger log = LoggerFactory.getLogger(HttpPropertiesLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromUrl(String httpUrl) throws IOException {
        URL url = new URL(httpUrl);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (InputStream inputStream = connection.getInputStream();){
                    Properties properties;
                    try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        Properties properties2 = new Properties();
                        properties2.load(reader);
                        reader.close();
                        inputStream.close();
                        properties2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> System.out.println(key + ": " + value)));
                        properties = properties2;
                    }
                    return properties;
                }
            }
            log.error("Failed to load properties. Url={}; Response Code={}", (Object)httpUrl, (Object)responseCode);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

