/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.i18n.runner;

import com.xinqiyi.framework.i18n.I18nMessageInitial;
import com.xinqiyi.framework.redis.RedisHelper;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class I18nPropertiesRunner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(I18nPropertiesRunner.class);
    private final ScheduledExecutorService schedulePool = new ScheduledThreadPoolExecutor(1);

    private String getI18nVersionRedisKey() {
        return "xinqiyi:i18n:version";
    }

    public void run(String ... args) throws Exception {
        try {
            I18nMessageInitial.initialLocalProperties();
            String i18nVersion = FastDateFormat.getInstance((String)"yyyyMMddHHmmssSSS").format(new Date());
            String[] cachedVersion = new String[]{i18nVersion};
            log.info("InitialI18nMessage.Success.Version={}", (Object)cachedVersion[0]);
            RedisHelper.getRedisTemplate().opsForValue().set((Object)this.getI18nVersionRedisKey(), (Object)i18nVersion);
            this.schedulePool.scheduleAtFixedRate(() -> {
                try {
                    String newVersion = (String)RedisHelper.getRedisTemplate().opsForValue().get((Object)this.getI18nVersionRedisKey());
                    if (!StringUtils.equalsIgnoreCase((CharSequence)cachedVersion[0], (CharSequence)newVersion)) {
                        log.info("CheckVersionChanged.ReInitialI18nMessage.OldVersion={};NewVersion={}", (Object)cachedVersion[0], (Object)newVersion);
                        I18nMessageInitial.initialLocalProperties();
                        cachedVersion[0] = newVersion;
                    }
                }
                catch (Exception e) {
                    log.error("I18nPropertiesRunner.scheduleAtFixedRate.Exception", (Throwable)e);
                }
            }, 5L, 60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            log.error("I18nPropertiesRunner.Run.Exception", (Throwable)ex);
        }
    }
}

