/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.mq;

import com.xinqiyi.framework.mq.IXinQiYiRocketMqService;
import com.xinqiyi.framework.mq.XinQiYiRocketMqType;
import com.xinqiyi.framework.mq.config.RocketMqServiceConfig;
import com.xinqiyi.framework.mq.impl.aliyun.AliyunRocketMqServiceImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class XinQiYiRocketMqServiceManager
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(XinQiYiRocketMqServiceManager.class);
    private final Map<String, IXinQiYiRocketMqService> mqServiceMap = new HashMap<String, IXinQiYiRocketMqService>();
    private final RocketMqServiceConfig rocketMqServiceConfig;
    private final AliyunRocketMqServiceImpl defaultRocketMqService;

    public void addOcrClient(String name, IXinQiYiRocketMqService rocketMqService) {
        if (this.mqServiceMap.containsKey(name)) {
            throw new RuntimeException("RocketMqService.Bean.Exist.Name=" + name);
        }
        this.mqServiceMap.put(name, rocketMqService);
        if (log.isInfoEnabled()) {
            log.info("XinQiYiRocketMqServiceManager.AddRocketMqService.Name={},Class={}", (Object)name, rocketMqService.getClass());
        }
    }

    public IXinQiYiRocketMqService getCurrentRocketMqService() {
        for (String code : this.mqServiceMap.keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)this.rocketMqServiceConfig.getRocketMqType())) continue;
            return this.mqServiceMap.get(code);
        }
        return this.defaultRocketMqService;
    }

    public Object postProcessAfterInitialization(Object bean, @NotNull String beanName) throws BeansException {
        XinQiYiRocketMqType rocketMqType = bean.getClass().getAnnotation(XinQiYiRocketMqType.class);
        if (rocketMqType != null && bean instanceof IXinQiYiRocketMqService) {
            this.addOcrClient(rocketMqType.code(), (IXinQiYiRocketMqService)bean);
        }
        return bean;
    }

    public XinQiYiRocketMqServiceManager(RocketMqServiceConfig rocketMqServiceConfig, AliyunRocketMqServiceImpl defaultRocketMqService) {
        this.rocketMqServiceConfig = rocketMqServiceConfig;
        this.defaultRocketMqService = defaultRocketMqService;
    }
}

